/// <reference path="./internal_*.d.ts" />
declare namespace com.tterrag.registrate.builders {
    class EnchantmentBuilder <T extends Internal.Enchantment, P> extends Internal.AbstractBuilder<Internal.Enchantment, T, P, com.tterrag.registrate.builders.EnchantmentBuilder<T, P>> {
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        lang(name: string): this;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        defaultLang(): this;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<Internal.Enchantment, T>, D>): this;
        addArmorSlots(): this;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): this;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        addSlots(...slots: Internal.EquipmentSlot_[]): this;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<com.tterrag.registrate.builders.EnchantmentBuilder<T, P>, S2>): S2;
        rarity(rarity: Internal.Enchantment$Rarity_): this;
        getEntry(): T;
        static create<T extends Internal.Enchantment, P>(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, type: Internal.EnchantmentCategory_, factory: Internal.EnchantmentBuilder$EnchantmentFactory_<T>): com.tterrag.registrate.builders.EnchantmentBuilder<T, P>;
        get(): Internal.RegistryEntry<T>;
        build(): P;
        get entry(): T
    }
    type EnchantmentBuilder_<T extends Internal.Enchantment, P> = EnchantmentBuilder<T, P>;
}
declare namespace dan200.computercraft.shared.peripheral.modem.wired {
    class CableBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock, Internal.EntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        onCustomDestroyBlock(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_): boolean;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        static correctConnections(world: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static canConnectIn(state: Internal.BlockState_, direction: Internal.Direction_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static doesConnectVisually(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        emi(): Internal.EmiStack;
        getCloneItemStack(state: Internal.BlockState_, hit: Internal.HitResult_, world: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_): Internal.ItemStack;
        onDestroyedByPlayer(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, willHarvest: boolean, fluid: Internal.FluidState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly MODEM: Internal.EnumProperty<Internal.CableModemVariant>;
        static readonly NORTH: Internal.BooleanProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly UP: Internal.BooleanProperty;
        static readonly CABLE: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly DOWN: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type CableBlock_ = CableBlock;
}
declare namespace Internal {
    class ChunkRenderMatrices extends Internal.Record {
        constructor(projection: Internal.Matrix4fc_, modelView: Internal.Matrix4fc_)
        static from(stack: Internal.PoseStack_): Internal.ChunkRenderMatrices;
        modelView(): Internal.Matrix4fc;
        projection(): Internal.Matrix4fc;
    }
    type ChunkRenderMatrices_ = ChunkRenderMatrices;
    interface InlineData <Self extends Internal.InlineData<Self>> {
        getExtraStyle(): Internal.Style;
        abstract getType(): Internal.InlineData$InlineDataType<Self>;
        asStyle(withExtra: boolean): Internal.Style;
        asText(withExtra: boolean): net.minecraft.network.chat.Component;
        abstract getRendererId(): ResourceLocation;
        get extraStyle(): Internal.Style
        get type(): Internal.InlineData$InlineDataType<Self>
        get rendererId(): ResourceLocation
    }
    type InlineData_<Self extends Internal.InlineData<Self>> = InlineData<Self>;
    interface ItemFTBL {
        abstract setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        (arg0: Internal.Item): void;
    }
    type ItemFTBL_ = ItemFTBL;
    class GameMasterBlockItem extends Internal.BlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type GameMasterBlockItem_ = GameMasterBlockItem;
    interface IEnergyService extends Internal.IGridService, Internal.IEnergySource {
        abstract isNetworkPowered(): boolean;
        abstract getChannelPowerUsage(): number;
        abstract getStoredPower(): number;
        abstract getAvgPowerInjection(): number;
        abstract getMaxStoredPower(): number;
        abstract getAvgPowerUsage(): number;
        abstract injectPower(arg0: number, arg1: Internal.Actionable_): number;
        abstract extractAEPower(arg0: number, arg1: Internal.Actionable_, arg2: Internal.PowerMultiplier_): number;
        abstract getEnergyDemand(arg0: number): number;
        abstract getIdlePowerUsage(): number;
        get networkPowered(): boolean
        get channelPowerUsage(): number
        get storedPower(): number
        get avgPowerInjection(): number
        get maxStoredPower(): number
        get avgPowerUsage(): number
        get idlePowerUsage(): number
    }
    type IEnergyService_ = IEnergyService;
    interface Map <K, V> {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        abstract containsValue(arg0: any): boolean;
        of<K, V>(): this;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): this;
        abstract containsKey(arg0: any): boolean;
        abstract put(arg0: K, arg1: V): V;
        abstract get(arg0: any): V;
        abstract remove(arg0: any): V;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): this;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        putIfAbsent(arg0: K, arg1: V): V;
        abstract keySet(): Internal.Set<K>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): this;
        abstract values(): Internal.Collection<V>;
        abstract entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): this;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): this;
        remove(arg0: any, arg1: any): boolean;
        abstract putAll(arg0: Internal.Map_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): this;
        abstract size(): number;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): this;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): this;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): this;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): this;
        abstract clear(): void;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): this;
        abstract equals(arg0: any): boolean;
        of<K, V>(arg0: K, arg1: V): this;
        get empty(): boolean
    }
    type Map_<K, V> = {[key in K]: V} | Map<K, V>;
    class ItemSeaSerpentScales extends Internal.ItemGeneric {
        constructor(colorName: string, color: Internal.ChatFormatting_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemSeaSerpentScales_ = ItemSeaSerpentScales;
    interface IUpgradeItem <T extends Internal.IUpgradeWrapper> {
        abstract getUpgradesPerStorage(arg0: string): number;
        abstract getName(): net.minecraft.network.chat.Component;
        getInventoryColumnsTaken(): number;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        abstract getUpgradeConflicts(): Internal.List<Internal.IUpgradeItem$UpgradeConflictDefinition>;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        getUpgradeGroup(): Internal.UpgradeGroup;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        abstract getUpgradesInGroupPerStorage(arg0: string): number;
        abstract getType(): Internal.UpgradeType<T>;
        get name(): net.minecraft.network.chat.Component
        get inventoryColumnsTaken(): number
        get upgradeConflicts(): Internal.List<Internal.IUpgradeItem$UpgradeConflictDefinition>
        get upgradeGroup(): Internal.UpgradeGroup
        get type(): Internal.UpgradeType<T>
    }
    type IUpgradeItem_<T extends Internal.IUpgradeWrapper> = IUpgradeItem<T>;
    class ConcentricRingsStructurePlacement extends Internal.StructurePlacement {
        constructor($$0: number, $$1: number, $$2: number, $$3: Internal.HolderSet_<Internal.Biome>)
        constructor($$0: Vec3i_, $$1: any_, $$2: number, $$3: number, $$4: Internal.Optional_<any>, $$5: number, $$6: number, $$7: number, $$8: Internal.HolderSet_<Internal.Biome>)
        distance(): number;
        count(): number;
        preferredBiomes(): Internal.HolderSet<Internal.Biome>;
        spread(): number;
        static readonly CODEC: Internal.Codec<Internal.ConcentricRingsStructurePlacement>;
    }
    type ConcentricRingsStructurePlacement_ = ConcentricRingsStructurePlacement;
    interface IStorageWrapper extends Internal.ITintable {
        abstract getDisplayName(): net.minecraft.network.chat.Component;
        setInventorySlotChangeHandler(slotChangeHandler: Internal.Runnable_): void;
        abstract sort(): void;
        abstract refreshInventoryForInputOutput(): void;
        abstract getStorageType(): string;
        getBaseStackSizeMultiplier(): number;
        abstract getSettingsHandler(): Internal.SettingsHandler;
        abstract getUpgradeHandler(): Internal.UpgradeHandler;
        getWrappedStorageStack(): Internal.ItemStack;
        onInit(): void;
        abstract refreshInventoryForUpgradeProcessing(): void;
        abstract setContentsChangeHandler(arg0: Internal.Runnable_): void;
        abstract getOpenTabId(): Internal.Optional<number>;
        getEnergyStorage(): Internal.Optional<Internal.EnergyStorage>;
        abstract setOpenTabId(arg0: number): void;
        abstract setPersistent(arg0: boolean): void;
        getNumberOfSlotRows(): number;
        abstract getContentsUuid(): Internal.Optional<Internal.UUID>;
        abstract getAccentColor(): number;
        abstract getSortBy(): Internal.SortBy;
        abstract getInventoryHandler(): Internal.InventoryHandler;
        abstract getMainColor(): number;
        abstract getColumnsTaken(): number;
        abstract onContentsNbtUpdated(): void;
        abstract setSortBy(arg0: Internal.SortBy_): void;
        getFluidHandler(): Internal.Optional<Internal.IStorageFluidHandler>;
        abstract getRenderInfo(): Internal.RenderInfo;
        setUpgradeCachesInvalidatedHandler(handler: Internal.Runnable_): void;
        abstract getInventoryForInputOutput(): Internal.ITrackedContentsItemHandler;
        abstract getInventoryForUpgradeProcessing(): Internal.ITrackedContentsItemHandler;
        abstract fillWithLoot(arg0: Internal.Player_): void;
        abstract removeOpenTabId(): void;
        abstract setColumnsTaken(arg0: number, arg1: boolean): void;
        abstract setColors(arg0: number, arg1: number): void;
        get displayName(): net.minecraft.network.chat.Component
        set inventorySlotChangeHandler(slotChangeHandler: Internal.Runnable_)
        get storageType(): string
        get baseStackSizeMultiplier(): number
        get settingsHandler(): Internal.SettingsHandler
        get upgradeHandler(): Internal.UpgradeHandler
        get wrappedStorageStack(): Internal.ItemStack
        set contentsChangeHandler(arg0: Internal.Runnable_)
        get openTabId(): Internal.Optional<number>
        get energyStorage(): Internal.Optional<Internal.EnergyStorage>
        set openTabId(arg0: number)
        set persistent(arg0: boolean)
        get numberOfSlotRows(): number
        get contentsUuid(): Internal.Optional<Internal.UUID>
        get accentColor(): number
        get sortBy(): Internal.SortBy
        get inventoryHandler(): Internal.InventoryHandler
        get mainColor(): number
        get columnsTaken(): number
        set sortBy(arg0: Internal.SortBy_)
        get fluidHandler(): Internal.Optional<Internal.IStorageFluidHandler>
        get renderInfo(): Internal.RenderInfo
        set upgradeCachesInvalidatedHandler(handler: Internal.Runnable_)
        get inventoryForInputOutput(): Internal.ITrackedContentsItemHandler
        get inventoryForUpgradeProcessing(): Internal.ITrackedContentsItemHandler
    }
    type IStorageWrapper_ = IStorageWrapper;
    class PacketType <T extends Internal.FabricPacket> {
        getId(): ResourceLocation;
        static create<P extends Internal.FabricPacket>(id: ResourceLocation_, constructor_: Internal.Function_<Internal.FriendlyByteBuf, P>): Internal.PacketType<P>;
        read(buf: Internal.FriendlyByteBuf_): T;
        get id(): ResourceLocation
    }
    type PacketType_<T extends Internal.FabricPacket> = PacketType<T>;
    abstract class EntityRenderer <T extends Internal.Entity> implements Internal.EntityRendererInter<any> {
        shadowShouldShowName(entity: Internal.Entity_): boolean;
        getFont(): net.minecraft.client.gui.Font;
        shadowRenderNameTag(entity: Internal.Entity_, component: net.minecraft.network.chat.Component_, poseStack: Internal.PoseStack_, multiBufferSource: Internal.MultiBufferSource_, light: number, delta: number): void;
        getRenderOffset($$0: T, $$1: number): Vec3d;
        abstract getTextureLocation(arg0: T): ResourceLocation;
        render($$0: T, $$1: number, $$2: number, $$3: Internal.PoseStack_, $$4: Internal.MultiBufferSource_, $$5: number): void;
        entityCullingIgnoresCulling(entity: Internal.Entity_): boolean;
        handler$zjj000$ad_astra$adastra$shouldRender(entity: Internal.Entity_, frustum: Internal.Frustum_, x: number, y: number, z: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        entityCullingGetCullingBox(entity: Internal.Entity_): Internal.AABB;
        getPackedLightCoords($$0: T, $$1: number): number;
        shouldRender($$0: T, $$1: Internal.Frustum_, $$2: number, $$3: number, $$4: number): boolean;
        get font(): net.minecraft.client.gui.Font
    }
    type EntityRenderer_<T extends Internal.Entity> = EntityRenderer<T>;
    abstract class DistanceManager {
        inEntityTickingRange($$0: number): boolean;
        addRegionTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        hasPlayersNearby($$0: number): boolean;
        removeTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        addPlayer($$0: Internal.SectionPos_, $$1: Internal.ServerPlayer_): void;
        runAllUpdates($$0: Internal.ChunkMap_): boolean;
        getDebugStatus(): string;
        hasTickets(): boolean;
        addTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        inBlockTickingRange($$0: number): boolean;
        removeRegionTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        removePlayer($$0: Internal.SectionPos_, $$1: Internal.ServerPlayer_): void;
        getNaturalSpawnChunkCount(): number;
        updateSimulationDistance($$0: number): void;
        removeTicketsOnClosing(): void;
        get debugStatus(): string
        get naturalSpawnChunkCount(): number
    }
    type DistanceManager_ = DistanceManager;
    class RecipeBookType extends Internal.Enum<Internal.RecipeBookType> {
        static values(): Internal.RecipeBookType[];
        static valueOf($$0: string): Internal.RecipeBookType;
        static readonly SMOKER: Internal.RecipeBookType;
        static readonly BLAST_FURNACE: Internal.RecipeBookType;
        static readonly CRAFTING: Internal.RecipeBookType;
        static readonly FURNACE: Internal.RecipeBookType;
        static readonly FARMERSDELIGHT_COOKING: Internal.RecipeBookType;
    }
    type RecipeBookType_ = "crafting" | RecipeBookType | "furnace" | "farmersdelight_cooking" | "blast_furnace" | "smoker";
    class ServerboundPlayerActionPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.ServerboundPlayerActionPacket$Action_, $$1: BlockPos_, $$2: Internal.Direction_)
        constructor($$0: Internal.ServerboundPlayerActionPacket$Action_, $$1: BlockPos_, $$2: Internal.Direction_, $$3: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        getAction(): Internal.ServerboundPlayerActionPacket$Action;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getSequence(): number;
        isSkippable(): boolean;
        getDirection(): Internal.Direction;
        get pos(): BlockPos
        get action(): Internal.ServerboundPlayerActionPacket$Action
        get sequence(): number
        get skippable(): boolean
        get direction(): Internal.Direction
    }
    type ServerboundPlayerActionPacket_ = ServerboundPlayerActionPacket;
    class AttachedToLeavesDecorator extends Internal.TreeDecorator {
        constructor($$0: number, $$1: number, $$2: number, $$3: Internal.BlockStateProvider_, $$4: number, $$5: Internal.List_<Internal.Direction>)
        static readonly CODEC: Internal.Codec<Internal.AttachedToLeavesDecorator>;
    }
    type AttachedToLeavesDecorator_ = AttachedToLeavesDecorator;
    class LiquidBlazeBurnerBlockEntity$FuelType extends Internal.Enum<Internal.LiquidBlazeBurnerBlockEntity$FuelType> {
        static valueOf(name: string): Internal.LiquidBlazeBurnerBlockEntity$FuelType;
        static values(): Internal.LiquidBlazeBurnerBlockEntity$FuelType[];
        static readonly SPECIAL: Internal.LiquidBlazeBurnerBlockEntity$FuelType;
        static readonly NONE: Internal.LiquidBlazeBurnerBlockEntity$FuelType;
        static readonly NORMAL: Internal.LiquidBlazeBurnerBlockEntity$FuelType;
    }
    type LiquidBlazeBurnerBlockEntity$FuelType_ = "normal" | LiquidBlazeBurnerBlockEntity$FuelType | "special" | "none";
    abstract class AbstractConnectorBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation, Internal.IObserveTileEntity, Internal.IDebugDrawer, Internal.IWireNode, Internal.EnergyTransferable {
        constructor(blockEntityTypeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        updateExternalEnergyStorage(): void;
        dropWires(world: Internal.Level_, dropItems: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        removeNode(node: Internal.LocalNode_, dropWire: boolean): void;
        isNodeIndeciesConnected(in_: number, other: number): boolean;
        abstract getMaxIn(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(nbt: Internal.CompoundTag_, clientPacket: boolean): void;
        static readNodeOtherIndex(nbt: Internal.CompoundTag_, index: number): number;
        getEnergyStorage(side: Internal.Direction_): Internal.EnergyStorage;
        abstract getMaxWireLength(): number;
        getPos(): BlockPos;
        invalidateNodeCache(): void;
        getNodeType(index: number): Internal.WireType;
        getNodeCount(): number;
        getOtherNodeIndex(index: number): number;
        abstract getConnectorType(): Internal.ConnectorType;
        getLocalNode(index: number): Internal.LocalNode;
        onLoad(): void;
        drawDebug(): void;
        isEnergyOutput(side: Internal.Direction_): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getConnectionTo(pos: BlockPos_): Internal.LocalNode;
        getMode(): Internal.ConnectorMode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        setNode(index: number, other: number, pos: BlockPos_, type: Internal.WireType_): void;
        invalidateCaps(): void;
        abstract getMaxOut(): number;
        asComponentProvider(): Internal.ComponentProvider;
        isEnergyInput(side: Internal.Direction_): boolean;
        removeNode(node: Internal.LocalNode_): void;
        static getWireNode(level: Internal.Level_, pos: BlockPos_): Internal.IWireNode;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getAvailableNode(pos: Vec3d_): number;
        handleWireCache(level: Internal.Level_, toDrop: Internal.Set_<Internal.LocalNode>): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        convertOldNbt(nbt: Internal.CompoundTag_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        static getWireNodeFrom(index: number, obj: Internal.IWireNode_, localNodes: Internal.LocalNode_[], nodeCache: Internal.IWireNode_[], level: Internal.Level_): Internal.IWireNode;
        abstract getNodeOffset(arg0: number): Vec3d;
        setNetwork(node: number, network: Internal.EnergyNetwork_): void;
        dropWires(world: Internal.Level_, player: Internal.Player_, dropItems: boolean): void;
        static readNodeWireType(nbt: Internal.CompoundTag_, index: number): Internal.WireType;
        validateLocalNodes(localNodes: Internal.LocalNode_[]): boolean;
        static dropWire(world: Internal.Level_, pos: BlockPos_, stack: Internal.ItemStack_): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        static getTypeOfConnection(level: Internal.Level_, pos1: BlockPos_, pos2: BlockPos_): Internal.WireType;
        removeNode(index: number, dropWire: boolean): void;
        getNodePos(index: number): BlockPos;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static getNbtNode(nbt: Internal.CompoundTag_, index: number): Internal.CompoundTag;
        dropWire(world: Internal.Level_, node: Internal.LocalNode_): void;
        getNetwork(node: number): Internal.EnergyNetwork;
        ignoreCapSide(): boolean;
        isNodeInput(index: number): boolean;
        read(nbt: Internal.CompoundTag_, clientPacket: boolean): void;
        static connect(world: Internal.Level_, pos1: BlockPos_, node1: number, pos2: BlockPos_, node2: number, type: Internal.WireType_): Internal.WireConnectResult;
        removeNode(index: number): void;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        isNodeOutput(node: number): boolean;
        getWireNode(index: number): Internal.IWireNode;
        static disconnect(world: Internal.Level_, pos1: BlockPos_, pos2: BlockPos_): Internal.WireConnectResult;
        invalidateLocalNodes(): void;
        isNetworkValid(node: number): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        firstTick(): void;
        hasAnyConnection(): boolean;
        hasConnectionTo(pos: BlockPos_): boolean;
        onObserved(player: Internal.ServerPlayer_, pack: Internal.ObservePacket_): void;
        static readNodeBlockPos(nbt: Internal.CompoundTag_, index: number, origin: BlockPos_): BlockPos;
        getInfiniteBoundingBox(): Internal.AABB;
        awakeNetwork(world: Internal.Level_): boolean;
        hasConnection(index: number): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        disconnectWires(): void;
        getCapacityOutside(): number;
        getAvailableNode(): number;
        get maxIn(): number
        get maxWireLength(): number
        get pos(): BlockPos
        get nodeCount(): number
        get connectorType(): Internal.ConnectorType
        get mode(): Internal.ConnectorMode
        get maxOut(): number
        get infiniteBoundingBox(): Internal.AABB
        get capacityOutside(): number
        get availableNode(): number
    }
    type AbstractConnectorBlockEntity_ = AbstractConnectorBlockEntity;
    class WrappedLevel extends Internal.Level {
        constructor(level: Internal.Level_)
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        createEntityList(entities: Internal.Collection_<Internal.Entity>): Internal.EntityArrayList;
        getEntitiesWithin(aabb: Internal.AABB_): Internal.EntityArrayList;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        runCommandSilent(command: string): number;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        asComponentProvider(): Internal.ComponentProvider;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        updateSnapshots(ctx: Internal.TransactionContext_): void;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        setChunkSource(source: Internal.ChunkSource_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        getBlock(blockEntity: Internal.BlockEntity_): Internal.BlockContainerJS;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        getDisplayName(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        getDirectSignalTo($$0: BlockPos_): number;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getBlock(x: number, y: number, z: number): Internal.BlockContainerJS;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        createExplosion(x: number, y: number, z: number): Internal.ExplosionJS;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        isPhased(pos: BlockPos_): boolean;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getDimension(): ResourceLocation;
        getDifficulty(): Internal.Difficulty;
        getName(): net.minecraft.network.chat.Component;
        canSeeSky($$0: BlockPos_): boolean;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        unmaskPhasedBlocks(): void;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        spawnFireworks(x: number, y: number, z: number, f: Internal.FireworksJS_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        phaseBlock(pos: BlockPos_, ticks: number): void;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        noCollision($$0: Internal.Entity_): boolean;
        self(): Internal.Level;
        createEntity(type: Internal.EntityType_<any>): Internal.Entity;
        getBestNeighborSignal($$0: BlockPos_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        hasChunk($$0: number, $$1: number): boolean;
        phaseBlock(pos: BlockPos_, ticks: number, delay: number, customSrc: DamageSource_): void;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getLevel(): Internal.Level;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        static getAllLoadedEntities(level: Internal.Level_): Internal.Iterable<Internal.Entity>;
        getSide(): Internal.ScriptType;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        remaskPhasedBlocks(): void;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        getEntities(): Internal.EntityArrayList;
        spawnParticles(options: Internal.ParticleOptions_, overrideLimiter: boolean, x: number, y: number, z: number, vx: number, vy: number, vz: number, count: number, speed: number): void;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getPlayers(): Internal.EntityArrayList;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        phaseBlock(pos: BlockPos_, ticks: number, delay: number): void;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getBlock(pos: BlockPos_): Internal.BlockContainerJS;
        isOverworld(): boolean;
        runCommand(command: string): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        set chunkSource(source: Internal.ChunkSource_)
        get displayName(): net.minecraft.network.chat.Component
        get dimension(): ResourceLocation
        get difficulty(): Internal.Difficulty
        get name(): net.minecraft.network.chat.Component
        get moonPhase(): number
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get level(): Internal.Level
        get moonBrightness(): number
        get side(): Internal.ScriptType
        get entities(): Internal.EntityArrayList
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get players(): Internal.EntityArrayList
        get maxLightLevel(): number
        get overworld(): boolean
    }
    type WrappedLevel_ = WrappedLevel;
    interface Stream <T> extends Internal.BaseStream<T, Internal.Stream<T>> {
        iterate<T>(arg0: T, arg1: Internal.UnaryOperator_<T>): this;
        abstract sorted(): this;
        abstract min(arg0: Internal.Comparator_<T>): Internal.Optional<T>;
        abstract reduce(arg0: T, arg1: Internal.BinaryOperator_<T>): T;
        abstract unordered(): this;
        empty<T>(): this;
        abstract isParallel(): boolean;
        toList(): Internal.List<T>;
        abstract anyMatch(arg0: Internal.Predicate_<T>): boolean;
        abstract collect<R>(arg0: Internal.Supplier_<R>, arg1: Internal.BiConsumer_<R, T>, arg2: Internal.BiConsumer_<R, R>): R;
        abstract parallel(): this;
        abstract limit(arg0: number): this;
        abstract count(): number;
        dropWhile(arg0: Internal.Predicate_<T>): this;
        concat<T>(arg0: Internal.Stream_<T>, arg1: Internal.Stream_<T>): this;
        mapMulti<R>(arg0: Internal.BiConsumer_<T, Internal.Consumer<R>>): Internal.Stream<R>;
        takeWhile(arg0: Internal.Predicate_<T>): this;
        mapMultiToDouble(arg0: Internal.BiConsumer_<T, Internal.DoubleConsumer>): Internal.DoubleStream;
        abstract findFirst(): Internal.Optional<T>;
        abstract allMatch(arg0: Internal.Predicate_<T>): boolean;
        of<T>(...arg0: T[]): this;
        abstract skip(arg0: number): this;
        builder<T>(): Internal.Stream$Builder<T>;
        abstract reduce<U>(arg0: U, arg1: Internal.BiFunction_<U, T, U>, arg2: Internal.BinaryOperator_<U>): U;
        iterate<T>(arg0: T, arg1: Internal.Predicate_<T>, arg2: Internal.UnaryOperator_<T>): this;
        abstract flatMapToLong(arg0: Internal.Function_<T, Internal.LongStream>): Internal.LongStream;
        abstract map<R>(arg0: Internal.Function_<T, R>): Internal.Stream<R>;
        abstract filter(arg0: Internal.Predicate_<T>): this;
        ofNullable<T>(arg0: T): this;
        mapMultiToLong(arg0: Internal.BiConsumer_<T, Internal.LongConsumer>): Internal.LongStream;
        abstract spliterator(): Internal.Spliterator<T>;
        abstract findAny(): Internal.Optional<T>;
        abstract mapToLong(arg0: Internal.ToLongFunction_<T>): Internal.LongStream;
        abstract forEachOrdered(arg0: Internal.Consumer_<T>): void;
        abstract iterator(): Internal.Iterator<T>;
        abstract forEach(arg0: Internal.Consumer_<T>): void;
        abstract flatMapToInt(arg0: Internal.Function_<T, Internal.IntStream>): Internal.IntStream;
        abstract collect<R, A>(arg0: Internal.Collector_<T, A, R>): R;
        abstract mapToInt(arg0: Internal.ToIntFunction_<T>): Internal.IntStream;
        abstract peek(arg0: Internal.Consumer_<T>): this;
        mapMultiToInt(arg0: Internal.BiConsumer_<T, Internal.IntConsumer>): Internal.IntStream;
        abstract onClose(arg0: Internal.Runnable_): this;
        abstract sorted(arg0: Internal.Comparator_<T>): this;
        abstract toArray(): any[];
        abstract toArray<A>(arg0: Internal.IntFunction_<A[]>): A[];
        abstract reduce(arg0: Internal.BinaryOperator_<T>): Internal.Optional<T>;
        of<T>(arg0: T): this;
        abstract flatMapToDouble(arg0: Internal.Function_<T, Internal.DoubleStream>): Internal.DoubleStream;
        abstract mapToDouble(arg0: Internal.ToDoubleFunction_<T>): Internal.DoubleStream;
        abstract distinct(): this;
        abstract close(): void;
        abstract max(arg0: Internal.Comparator_<T>): Internal.Optional<T>;
        abstract flatMap<R>(arg0: Internal.Function_<T, Internal.Stream<R>>): Internal.Stream<R>;
        abstract sequential(): this;
        abstract noneMatch(arg0: Internal.Predicate_<T>): boolean;
        generate<T>(arg0: Internal.Supplier_<T>): this;
        get parallel(): boolean
    }
    type Stream_<T> = Stream<T>;
    class Marker extends Internal.Entity {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type Marker_ = Marker;
    class RichSoilBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static init(): void;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type RichSoilBlock_ = RichSoilBlock;
    interface AccessScreen {
        abstract controlling$getRenderables(): Internal.List<Internal.Renderable>;
        (): Internal.List_<Internal.Renderable>;
    }
    type AccessScreen_ = AccessScreen;
    class EmiRecipeCategory implements Internal.EmiRenderable {
        constructor(id: ResourceLocation_, icon: Internal.EmiRenderable_, simplified: Internal.EmiRenderable_)
        constructor(id: ResourceLocation_, icon: Internal.EmiRenderable_)
        constructor(id: ResourceLocation_, icon: Internal.EmiRenderable_, simplified: Internal.EmiRenderable_, sorter: Internal.Comparator_<Internal.EmiRecipe>)
        getName(): net.minecraft.network.chat.Component;
        getId(): ResourceLocation;
        getSort(): Internal.Comparator<Internal.EmiRecipe>;
        getTooltip(): Internal.List<Internal.ClientTooltipComponent>;
        render(draw: Internal.GuiGraphics_, x: number, y: number, delta: number): void;
        renderSimplified(draw: Internal.GuiGraphics_, x: number, y: number, delta: number): void;
        get name(): net.minecraft.network.chat.Component
        get id(): ResourceLocation
        get sort(): Internal.Comparator<Internal.EmiRecipe>
        get tooltip(): Internal.List<Internal.ClientTooltipComponent>
        sorter: Internal.Comparator<Internal.EmiRecipe>;
        simplified: Internal.EmiRenderable;
        id: ResourceLocation;
        icon: Internal.EmiRenderable;
    }
    type EmiRecipeCategory_ = EmiRecipeCategory;
    interface Function8 <T1, T2, T3, T4, T5, T6, T7, T8, R> {
        curry5(): Internal.Function5<T1, T2, T3, T4, T5, Internal.Function3<T6, T7, T8, R>>;
        curry7(): Internal.Function7<T1, T2, T3, T4, T5, T6, T7, Internal.Function<T8, R>>;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function6<T3, T4, T5, T6, T7, T8, R>>;
        abstract apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7, arg7: T8): R;
        curry6(): Internal.Function6<T1, T2, T3, T4, T5, T6, Internal.BiFunction<T7, T8, R>>;
        curry(): Internal.Function<T1, Internal.Function7<T2, T3, T4, T5, T6, T7, T8, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.Function4<T5, T6, T7, T8, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function5<T4, T5, T6, T7, T8, R>>;
        (arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7, arg7: T8): R;
    }
    type Function8_<T1, T2, T3, T4, T5, T6, T7, T8, R> = Function8<T1, T2, T3, T4, T5, T6, T7, T8, R>;
    interface Function9 <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> {
        curry8(): Internal.Function8<T1, T2, T3, T4, T5, T6, T7, T8, Internal.Function<T9, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function6<T4, T5, T6, T7, T8, T9, R>>;
        curry5(): Internal.Function5<T1, T2, T3, T4, T5, Internal.Function4<T6, T7, T8, T9, R>>;
        curry(): Internal.Function<T1, Internal.Function8<T2, T3, T4, T5, T6, T7, T8, T9, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.Function5<T5, T6, T7, T8, T9, R>>;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function7<T3, T4, T5, T6, T7, T8, T9, R>>;
        abstract apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7, arg7: T8, arg8: T9): R;
        curry7(): Internal.Function7<T1, T2, T3, T4, T5, T6, T7, Internal.BiFunction<T8, T9, R>>;
        curry6(): Internal.Function6<T1, T2, T3, T4, T5, T6, Internal.Function3<T7, T8, T9, R>>;
        (arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7, arg7: T8, arg8: T9): R;
    }
    type Function9_<T1, T2, T3, T4, T5, T6, T7, T8, T9, R> = Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>;
    class CommandSourceStack implements Internal.SharedSuggestionProvider {
        constructor($$0: Internal.CommandSource_, $$1: Vec3d_, $$2: Internal.Vec2_, $$3: Internal.ServerLevel_, $$4: number, $$5: string, $$6: net.minecraft.network.chat.Component_, $$7: Internal.MinecraftServer_, $$8: Internal.Entity_)
        sendFailure($$0: net.minecraft.network.chat.Component_): void;
        static suggest($$0: Internal.Stream_<string>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static suggest($$0: string[], $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        hasPermission($$0: number): boolean;
        getPlayer(): Internal.ServerPlayer;
        static suggestResource<T>($$0: Internal.Iterable_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        getCustomTabSugggestions(): Internal.Collection<string>;
        getRotation(): Internal.Vec2;
        getRecipeNames(): Internal.Stream<ResourceLocation>;
        sendSuccess(component: net.minecraft.network.chat.Component_, broadcastToAdmins: boolean): void;
        getAnchor(): Internal.EntityAnchorArgument$Anchor;
        static filterResources<T>($$0: Internal.Iterable_<T>, $$1: string, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Consumer_<T>): void;
        getTextName(): string;
        sendChatMessage($$0: Internal.OutgoingChatMessage_, $$1: boolean, $$2: Internal.ChatType$Bound_): void;
        withChatMessageChainer($$0: Internal.TaskChainer_): this;
        withLevel($$0: Internal.ServerLevel_): this;
        static suggest2DCoordinates($$0: string, $$1: Internal.Collection_<Internal.SharedSuggestionProvider$TextCoordinates>, $$2: Internal.SuggestionsBuilder_, $$3: Internal.Predicate_<string>): Internal.CompletableFuture<Internal.Suggestions>;
        withPermission($$0: number): this;
        withAnchor($$0: Internal.EntityAnchorArgument$Anchor_): this;
        customSuggestion($$0: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        static suggestResource($$0: Internal.Iterable_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggestRegistryElements($$0: Internal.Registry_<any>, $$1: Internal.SharedSuggestionProvider$ElementSuggestionType_, $$2: Internal.SuggestionsBuilder_): void;
        enabledFeatures(): Internal.FeatureFlagSet;
        isPlayer(): boolean;
        getAllTeams(): Internal.Collection<string>;
        facing($$0: Internal.Entity_, $$1: Internal.EntityAnchorArgument$Anchor_): this;
        withEntity($$0: Internal.Entity_): this;
        withReturnValueConsumer($$0: Internal.IntConsumer_): this;
        static filterResources<T>($$0: Internal.Iterable_<T>, $$1: string, $$2: string, $$3: Internal.Function_<T, ResourceLocation>, $$4: Internal.Consumer_<T>): void;
        getRelevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        getAbsoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        withRotation($$0: Internal.Vec2_): this;
        getEntity(): Internal.Entity;
        static suggestResource($$0: Internal.Iterable_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_, $$2: string): Internal.CompletableFuture<Internal.Suggestions>;
        levels(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        getOnlinePlayerNames(): Internal.Collection<string>;
        shouldFilterMessageTo($$0: Internal.ServerPlayer_): boolean;
        getServer(): Internal.MinecraftServer;
        withCallback($$0: Internal.ResultConsumer_<Internal.CommandSourceStack>): this;
        static suggestResource<T>($$0: Internal.Stream_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        getDisplayName(): net.minecraft.network.chat.Component;
        getSelectedEntities(): Internal.Collection<string>;
        getLevel(): Internal.ServerLevel;
        getPosition(): Vec3d;
        withCallback($$0: Internal.ResultConsumer_<Internal.CommandSourceStack>, $$1: Internal.BinaryOperator_<Internal.ResultConsumer<Internal.CommandSourceStack>>): this;
        onCommandComplete($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: boolean, $$2: number): void;
        getSigningContext(): Internal.CommandSigningContext;
        withPosition($$0: Vec3d_): this;
        static suggestCoordinates($$0: string, $$1: Internal.Collection_<Internal.SharedSuggestionProvider$TextCoordinates>, $$2: Internal.SuggestionsBuilder_, $$3: Internal.Predicate_<string>): Internal.CompletableFuture<Internal.Suggestions>;
        static suggestResource($$0: Internal.Stream_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        withSuppressedOutput(): this;
        withMaximumPermission($$0: number): this;
        getReturnValueConsumer(): Internal.IntConsumer;
        static suggestResource($$0: Internal.Stream_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_, $$2: string): Internal.CompletableFuture<Internal.Suggestions>;
        getEntityOrException(): Internal.Entity;
        static matchesSubStr($$0: string, $$1: string): boolean;
        static suggest<T>($$0: Internal.Iterable_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, string>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        withSigningContext($$0: Internal.CommandSigningContext_): this;
        static suggest($$0: Internal.Iterable_<string>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        getAvailableSounds(): Internal.Stream<ResourceLocation>;
        suggestRegistryElements($$0: Internal.ResourceKey_<Internal.Registry<any>>, $$1: Internal.SharedSuggestionProvider$ElementSuggestionType_, $$2: Internal.SuggestionsBuilder_, $$3: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        sendSuccessLazy(component: Internal.LazyComponentKJS_, broadcastToAdmins: boolean): void;
        registryAccess(): Internal.RegistryAccess;
        getPlayerOrException(): Internal.ServerPlayer;
        getChatMessageChainer(): Internal.TaskChainer;
        facing($$0: Vec3d_): this;
        sendSystemMessage($$0: net.minecraft.network.chat.Component_): void;
        withSource($$0: Internal.CommandSource_): this;
        get player(): Internal.ServerPlayer
        get customTabSugggestions(): Internal.Collection<string>
        get rotation(): Internal.Vec2
        get recipeNames(): Internal.Stream<ResourceLocation>
        get anchor(): Internal.EntityAnchorArgument$Anchor
        get textName(): string
        get player(): boolean
        get allTeams(): Internal.Collection<string>
        get relevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>
        get absoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>
        get entity(): Internal.Entity
        get onlinePlayerNames(): Internal.Collection<string>
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        get selectedEntities(): Internal.Collection<string>
        get level(): Internal.ServerLevel
        get position(): Vec3d
        get signingContext(): Internal.CommandSigningContext
        get returnValueConsumer(): Internal.IntConsumer
        get entityOrException(): Internal.Entity
        get availableSounds(): Internal.Stream<ResourceLocation>
        get playerOrException(): Internal.ServerPlayer
        get chatMessageChainer(): Internal.TaskChainer
        static readonly ERROR_NOT_PLAYER: Internal.SimpleCommandExceptionType;
        static readonly ERROR_NOT_ENTITY: Internal.SimpleCommandExceptionType;
    }
    type CommandSourceStack_ = CommandSourceStack;
    interface Function4 <T1, T2, T3, T4, R> {
        curry2(): Internal.BiFunction<T1, T2, Internal.BiFunction<T3, T4, R>>;
        abstract apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4): R;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function<T4, R>>;
        curry(): Internal.Function<T1, Internal.Function3<T2, T3, T4, R>>;
        (arg0: T1, arg1: T2, arg2: T3, arg3: T4): R;
    }
    type Function4_<T1, T2, T3, T4, R> = Function4<T1, T2, T3, T4, R>;
    class FrameForEach$Companion$TYPE$1 implements Internal.ContinuationFrame$Type<Internal.FrameForEach> {
        deserializeFromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.FrameForEach;
    }
    type FrameForEach$Companion$TYPE$1_ = FrameForEach$Companion$TYPE$1;
    interface Function5 <T1, T2, T3, T4, T5, R> {
        abstract apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5): R;
        curry(): Internal.Function<T1, Internal.Function4<T2, T3, T4, T5, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.Function<T5, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.BiFunction<T4, T5, R>>;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function3<T3, T4, T5, R>>;
        (arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5): R;
    }
    type Function5_<T1, T2, T3, T4, T5, R> = Function5<T1, T2, T3, T4, T5, R>;
    interface Function6 <T1, T2, T3, T4, T5, T6, R> {
        curry(): Internal.Function<T1, Internal.Function5<T2, T3, T4, T5, T6, R>>;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function4<T3, T4, T5, T6, R>>;
        curry5(): Internal.Function5<T1, T2, T3, T4, T5, Internal.Function<T6, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function3<T4, T5, T6, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.BiFunction<T5, T6, R>>;
        abstract apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6): R;
        (arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6): R;
    }
    type Function6_<T1, T2, T3, T4, T5, T6, R> = Function6<T1, T2, T3, T4, T5, T6, R>;
    interface Function7 <T1, T2, T3, T4, T5, T6, T7, R> {
        curry6(): Internal.Function6<T1, T2, T3, T4, T5, T6, Internal.Function<T7, R>>;
        curry5(): Internal.Function5<T1, T2, T3, T4, T5, Internal.BiFunction<T6, T7, R>>;
        curry4(): Internal.Function4<T1, T2, T3, T4, Internal.Function3<T5, T6, T7, R>>;
        curry3(): Internal.Function3<T1, T2, T3, Internal.Function4<T4, T5, T6, T7, R>>;
        curry(): Internal.Function<T1, Internal.Function6<T2, T3, T4, T5, T6, T7, R>>;
        abstract apply(arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7): R;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function5<T3, T4, T5, T6, T7, R>>;
        (arg0: T1, arg1: T2, arg2: T3, arg3: T4, arg4: T5, arg5: T6, arg6: T7): R;
    }
    type Function7_<T1, T2, T3, T4, T5, T6, T7, R> = Function7<T1, T2, T3, T4, T5, T6, T7, R>;
    class GlobeBlock extends Internal.BasicEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type GlobeBlock_ = GlobeBlock;
    class CraftingPatternItem extends Internal.EncodedPatternItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        encode(recipe: Internal.CraftingRecipe_, in_: Internal.ItemStack_[], out: Internal.ItemStack_, allowSubstitutes: boolean, allowFluidSubstitutes: boolean): Internal.ItemStack;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CraftingPatternItem_ = CraftingPatternItem;
    class ElevatorColumn {
        constructor(level: Internal.LevelAccessor_, coords: Internal.ElevatorColumn$ColumnCoords_)
        static get(level: Internal.LevelAccessor_, coords: Internal.ElevatorColumn$ColumnCoords_): Internal.ElevatorColumn;
        markDirty(): void;
        contactAt(y: number): BlockPos;
        target(yLevel: number): void;
        floorReached(level: Internal.LevelAccessor_, name: string): void;
        gatherAll(): void;
        namesChanged(): void;
        isActive(): boolean;
        initNames(level: Internal.Level_): void;
        compileNamesList(): Internal.List<Internal.IntAttached<Internal.Couple<string>>>;
        isTargetAvailable(): boolean;
        static getOrCreate(level: Internal.LevelAccessor_, coords: Internal.ElevatorColumn$ColumnCoords_): Internal.ElevatorColumn;
        add(contactPos: BlockPos_): void;
        getContacts(): Internal.Collection<BlockPos>;
        getTargetedYLevel(): number;
        setActive(isActive: boolean): void;
        remove(contactPos: BlockPos_): void;
        get active(): boolean
        get targetAvailable(): boolean
        get contacts(): Internal.Collection<BlockPos>
        get targetedYLevel(): number
        set active(isActive: boolean)
        static LOADED_COLUMNS: Internal.WorldAttached<Internal.Map<Internal.ElevatorColumn$ColumnCoords, Internal.ElevatorColumn>>;
        namesListVersion: number;
    }
    type ElevatorColumn_ = ElevatorColumn;
    interface LevelData extends Internal.ComponentProvider, Internal.MixinWorldProperties {
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        abstract getDifficulty(): Internal.Difficulty;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        abstract isThundering(): boolean;
        fillCrashReportCategory($$0: Internal.CrashReportCategory_, $$1: Internal.LevelHeightAccessor_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        abstract isDifficultyLocked(): boolean;
        asComponentProvider(): Internal.ComponentProvider;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        abstract isRaining(): boolean;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        abstract getSpawnAngle(): number;
        abstract setRaining(arg0: boolean): void;
        abstract getGameRules(): Internal.GameRules;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        abstract isHardcore(): boolean;
        abstract getYSpawn(): number;
        abstract getGameTime(): number;
        abstract getComponentContainer(): Internal.ComponentContainer;
        abstract getZSpawn(): number;
        abstract getDayTime(): number;
        abstract getXSpawn(): number;
        get difficulty(): Internal.Difficulty
        get thundering(): boolean
        get difficultyLocked(): boolean
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get raining(): boolean
        get spawnAngle(): number
        set raining(arg0: boolean)
        get gameRules(): Internal.GameRules
        get hardcore(): boolean
        get YSpawn(): number
        get gameTime(): number
        get componentContainer(): Internal.ComponentContainer
        get ZSpawn(): number
        get dayTime(): number
        get XSpawn(): number
    }
    type LevelData_ = LevelData;
    interface Function3 <T1, T2, T3, R> {
        abstract apply(arg0: T1, arg1: T2, arg2: T3): R;
        curry2(): Internal.BiFunction<T1, T2, Internal.Function<T3, R>>;
        curry(): Internal.Function<T1, Internal.BiFunction<T2, T3, R>>;
        (arg0: T1, arg1: T2, arg2: T3): R;
    }
    type Function3_<T1, T2, T3, R> = Function3<T1, T2, T3, R>;
    class ComponentValueMap extends Internal.IdentityHashMap<Internal.RecipeKey<any>, any> {
        constructor(init: number)
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: Internal.RecipeKey_<any>, arg1: Internal.BiFunction_<Internal.RecipeKey<any>, any, any>): any;
        computeIfPresent(arg0: Internal.RecipeKey_<any>, arg1: Internal.BiFunction_<Internal.RecipeKey<any>, any, any>): any;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: any): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        merge(arg0: Internal.RecipeKey_<any>, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: Internal.RecipeKey_<any>, arg1: Internal.Function_<Internal.RecipeKey<any>, any>): any;
        replace(arg0: Internal.RecipeKey_<any>, arg1: any): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        putIfAbsent(arg0: Internal.RecipeKey_<any>, arg1: any): any;
        getValue<T>(recipe: Internal.RecipeJS_, key: Internal.RecipeKey_<T>): T;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type ComponentValueMap_ = ComponentValueMap;
    interface NativeResource extends Internal.AutoCloseable {
        abstract free(): void;
        close(): void;
        (): void;
    }
    type NativeResource_ = NativeResource;
    class Display$TextDisplay$CachedLine extends Internal.Record {
        constructor($$0: Internal.FormattedCharSequence_, $$1: number)
        contents(): Internal.FormattedCharSequence;
        width(): number;
    }
    type Display$TextDisplay$CachedLine_ = Display$TextDisplay$CachedLine;
    class TrackBlockItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getPlacementState(pContext: Internal.UseOnContext_): Internal.BlockState;
        static select(world: Internal.LevelAccessor_, pos: BlockPos_, lookVec: Vec3d_, heldItem: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static sendExtenderPacket(player: Internal.Player_, world: Internal.Level_, hand: Internal.InteractionHand_, hitResult: Internal.BlockHitResult_): Internal.InteractionResult;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        static clearSelection(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): Internal.InteractionResultHolder<Internal.ItemStack>;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TrackBlockItem_ = TrackBlockItem;
    interface TransportedItemStackHandlerBehaviour$PositionGetter {
        abstract getWorldPositionVector(arg0: Internal.TransportedItemStack_): Vec3d;
        (arg0: Internal.TransportedItemStack): Vec3d_;
    }
    type TransportedItemStackHandlerBehaviour$PositionGetter_ = TransportedItemStackHandlerBehaviour$PositionGetter;
    class CursorType extends Internal.Enum<Internal.CursorType> {
        static values(): Internal.CursorType[];
        static set(type: Internal.CursorType_): void;
        static valueOf(name: string): Internal.CursorType;
        static readonly HAND: Internal.CursorType;
        static readonly ARROW: Internal.CursorType;
        static readonly HRESIZE: Internal.CursorType;
        static readonly IBEAM: Internal.CursorType;
        static readonly VRESIZE: Internal.CursorType;
        static readonly CROSSHAIR: Internal.CursorType;
    }
    type CursorType_ = "crosshair" | "ibeam" | CursorType | "vresize" | "hand" | "arrow" | "hresize";
    abstract class BlockLootSubProvider implements Internal.FabricBlockLootTableGenerator, Internal.LootTableSubProvider, com.simibubi.create.foundation.mixin.accessor.BlockLootSubProviderAccessor, Internal.BlockLootSubProviderAccessor {
        dropPottedContents($$0: Internal.Block_): void;
        generate($$0: Internal.BiConsumer_<ResourceLocation, Internal.LootTable$Builder>): void;
        createSlabItemTable($$0: Internal.Block_): Internal.LootTable$Builder;
        createLeavesDrops($$0: Internal.Block_, $$1: Internal.Block_, ...$$2: number[]): Internal.LootTable$Builder;
        createOreDrop($$0: Internal.Block_, $$1: Internal.Item_): Internal.LootTable$Builder;
        dropSelf($$0: Internal.Block_): void;
        static createShearsDispatchTable($$0: Internal.Block_, $$1: Internal.LootPoolEntryContainer$Builder_<any>): Internal.LootTable$Builder;
        abstract generate(): void;
        createBannerDrop($$0: Internal.Block_): Internal.LootTable$Builder;
        static createDoublePlantShearsDrop($$0: Internal.Block_): Internal.LootTable$Builder;
        withConditions(...conditions: any_[]): this;
        createShulkerBoxDrop($$0: Internal.Block_): Internal.LootTable$Builder;
        static noDrop(): Internal.LootTable$Builder;
        createAttachedStemDrops($$0: Internal.Block_, $$1: Internal.Item_): Internal.LootTable$Builder;
        otherWhenSilkTouch($$0: Internal.Block_, $$1: Internal.Block_): void;
        getMap(): Internal.Map<any, any>;
        createSingleItemTableWithSilkTouch($$0: Internal.Block_, $$1: Internal.ItemLike_, $$2: Internal.NumberProvider_): Internal.LootTable$Builder;
        static createCaveVinesDrop($$0: Internal.Block_): Internal.LootTable$Builder;
        static createSilkTouchOrShearsDispatchTable($$0: Internal.Block_, $$1: Internal.LootPoolEntryContainer$Builder_<any>): Internal.LootTable$Builder;
        createRedstoneOreDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        static createSilkTouchOnlyTable($$0: Internal.ItemLike_): Internal.LootTable$Builder;
        createOakLeavesDrops($$0: Internal.Block_, $$1: Internal.Block_, ...$$2: number[]): Internal.LootTable$Builder;
        createCropDrops($$0: Internal.Block_, $$1: Internal.Item_, $$2: Internal.Item_, $$3: Internal.LootItemCondition$Builder_): Internal.LootTable$Builder;
        static createCandleCakeDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        createPetalsDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        createStemDrops($$0: Internal.Block_, $$1: Internal.Item_): Internal.LootTable$Builder;
        dropOther($$0: Internal.Block_, $$1: Internal.ItemLike_): void;
        createSingleItemTable($$0: Internal.ItemLike_, $$1: Internal.NumberProvider_): Internal.LootTable$Builder;
        createMangroveLeavesDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        add($$0: Internal.Block_, $$1: Internal.Function_<Internal.Block, Internal.LootTable$Builder>): void;
        dropWhenSilkTouch($$0: Internal.Block_): void;
        addNetherVinesDropTable($$0: Internal.Block_, $$1: Internal.Block_): void;
        static createBeeHiveDrop($$0: Internal.Block_): Internal.LootTable$Builder;
        static create$HAS_SILK_TOUCH(): Internal.LootItemCondition$Builder;
        static HAS_SILK_TOUCH$create_$md$fca01f$0(): Internal.LootItemCondition$Builder;
        static createShearsOnlyDrop($$0: Internal.ItemLike_): Internal.LootTable$Builder;
        createDoorTable($$0: Internal.Block_): Internal.LootTable$Builder;
        createMultifaceBlockDrops($$0: Internal.Block_, $$1: Internal.LootItemCondition$Builder_): Internal.LootTable$Builder;
        add($$0: Internal.Block_, $$1: Internal.LootTable$Builder_): void;
        createDoublePlantWithSeedDrops($$0: Internal.Block_, $$1: Internal.Block_): Internal.LootTable$Builder;
        applyExplosionCondition<T extends Internal.ConditionUserBuilder<T>>($$0: Internal.ItemLike_, $$1: Internal.ConditionUserBuilder_<T>): T;
        createCandleDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        static createSelfDropDispatchTable($$0: Internal.Block_, $$1: Internal.LootItemCondition$Builder_, $$2: Internal.LootPoolEntryContainer$Builder_<any>): Internal.LootTable$Builder;
        createPotFlowerItemTable($$0: Internal.ItemLike_): Internal.LootTable$Builder;
        static createSilkTouchDispatchTable($$0: Internal.Block_, $$1: Internal.LootPoolEntryContainer$Builder_<any>): Internal.LootTable$Builder;
        applyExplosionDecay<T extends Internal.FunctionUserBuilder<T>>($$0: Internal.ItemLike_, $$1: Internal.FunctionUserBuilder_<T>): T;
        createCopperOreDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        createLapisOreDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        createSinglePropConditionTable<T extends Internal.Comparable<T> & Internal.StringRepresentable>($$0: Internal.Block_, $$1: Internal.Property_<T>, $$2: T): Internal.LootTable$Builder;
        createSingleItemTableWithSilkTouch($$0: Internal.Block_, $$1: Internal.ItemLike_): Internal.LootTable$Builder;
        static createBeeNestDrop($$0: Internal.Block_): Internal.LootTable$Builder;
        createMushroomBlockDrop($$0: Internal.Block_, $$1: Internal.ItemLike_): Internal.LootTable$Builder;
        createSingleItemTable($$0: Internal.ItemLike_): Internal.LootTable$Builder;
        createGrassDrops($$0: Internal.Block_): Internal.LootTable$Builder;
        createNameableBlockEntityTable($$0: Internal.Block_): Internal.LootTable$Builder;
        get map(): Internal.Map<any, any>
        readonly map: Internal.Map<ResourceLocation, Internal.LootTable$Builder>;
        static readonly HAS_SILK_TOUCH: Internal.LootItemCondition$Builder;
        static readonly HAS_NO_SILK_TOUCH: Internal.LootItemCondition$Builder;
        static readonly HAS_SHEARS_OR_SILK_TOUCH: Internal.AnyOfCondition$Builder;
        static readonly HAS_SHEARS: Internal.LootItemCondition$Builder;
        static readonly HAS_NO_SHEARS_OR_SILK_TOUCH: Internal.LootItemCondition$Builder;
        static readonly NORMAL_LEAVES_SAPLING_CHANCES: number[];
        static readonly NORMAL_LEAVES_STICK_CHANCES: number[];
    }
    type BlockLootSubProvider_ = BlockLootSubProvider;
    interface AccessorCarriage {
        abstract getSerialisedPassengers(): Internal.Map<number, Internal.CompoundTag>;
        get serialisedPassengers(): Internal.Map<number, Internal.CompoundTag>
        (): Internal.Map_<number, Internal.CompoundTag>;
    }
    type AccessorCarriage_ = AccessorCarriage;
    class StructureSet$StructureSelectionEntry extends Internal.Record {
        constructor($$0: Internal.Holder_<Internal.Structure>, $$1: number)
        structure(): Internal.Holder<Internal.Structure>;
        weight(): number;
        static readonly CODEC: Internal.Codec<Internal.StructureSet$StructureSelectionEntry>;
    }
    type StructureSet$StructureSelectionEntry_ = StructureSet$StructureSelectionEntry;
    class ClientboundSetDisplayObjectivePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: Internal.Objective_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getSlot(): number;
        isSkippable(): boolean;
        getObjectiveName(): string;
        get slot(): number
        get skippable(): boolean
        get objectiveName(): string
    }
    type ClientboundSetDisplayObjectivePacket_ = ClientboundSetDisplayObjectivePacket;
    class SkyChestBlock$SkyChestType extends Internal.Enum<Internal.SkyChestBlock$SkyChestType> {
        static values(): Internal.SkyChestBlock$SkyChestType[];
        static valueOf(name: string): Internal.SkyChestBlock$SkyChestType;
        static readonly STONE: Internal.SkyChestBlock$SkyChestType;
        static readonly BLOCK: Internal.SkyChestBlock$SkyChestType;
    }
    type SkyChestBlock$SkyChestType_ = "block" | SkyChestBlock$SkyChestType | "stone";
    class TntBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static explode($$0: Internal.Level_, $$1: BlockPos_): void;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        static explode($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.LivingEntity_): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly UNSTABLE: Internal.BooleanProperty;
    }
    type TntBlock_ = TntBlock;
    class CreativeModeTab$Type extends Internal.Enum<Internal.CreativeModeTab$Type> {
        static values(): Internal.CreativeModeTab$Type[];
        static valueOf($$0: string): Internal.CreativeModeTab$Type;
        static readonly CATEGORY: Internal.CreativeModeTab$Type;
        static readonly INVENTORY: Internal.CreativeModeTab$Type;
        static readonly SEARCH: Internal.CreativeModeTab$Type;
        static readonly HOTBAR: Internal.CreativeModeTab$Type;
    }
    type CreativeModeTab$Type_ = "hotbar" | "search" | CreativeModeTab$Type | "category" | "inventory";
    class ConjuredCompassItem extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ConjuredCompassItem_ = ConjuredCompassItem;
    class MoltenMetalBucketItem extends Internal.ModBucketItem {
        constructor(fluid: Internal.Fluid_, properties: Internal.Item$Properties_)
        arch$getFluid(): Internal.Fluid;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MoltenMetalBucketItem_ = MoltenMetalBucketItem;
    class VibrationInfo extends Internal.Record {
        constructor($$0: Internal.GameEvent_, $$1: number, $$2: Vec3d_, $$3: Internal.UUID_, $$4: Internal.UUID_, $$5: Internal.Entity_)
        constructor($$0: Internal.GameEvent_, $$1: number, $$2: Vec3d_, $$3: Internal.Entity_)
        constructor($$0: Internal.GameEvent_, $$1: number, $$2: Vec3d_, $$3: Internal.UUID_, $$4: Internal.UUID_)
        gameEvent(): Internal.GameEvent;
        distance(): number;
        projectileOwnerUuid(): Internal.UUID;
        getProjectileOwner($$0: Internal.ServerLevel_): Internal.Optional<Internal.Entity>;
        pos(): Vec3d;
        entity(): Internal.Entity;
        uuid(): Internal.UUID;
        getEntity($$0: Internal.ServerLevel_): Internal.Optional<Internal.Entity>;
        static readonly CODEC: Internal.Codec<Internal.VibrationInfo>;
    }
    type VibrationInfo_ = VibrationInfo;
    interface LandPathNodeTypesRegistry$PathNodeTypeProvider {
    }
    type LandPathNodeTypesRegistry$PathNodeTypeProvider_ = LandPathNodeTypesRegistry$PathNodeTypeProvider;
    class CabinetBlock extends Internal.BaseEntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly OPEN: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type CabinetBlock_ = CabinetBlock;
    class RayTraceResultJS {
        constructor(from: Internal.Entity_, result: Internal.HitResult_, d: number)
        getHitX(): number;
        getHitY(): number;
        getHitZ(): number;
        get hitX(): number
        get hitY(): number
        get hitZ(): number
        hit: Vec3d;
        facing: Internal.Direction;
        block: Internal.BlockContainerJS;
        readonly fromEntity: Internal.Entity;
        readonly type: Internal.HitResult$Type;
        readonly distance: number;
        entity: Internal.Entity;
    }
    type RayTraceResultJS_ = RayTraceResultJS;
    class BrewingStandBlockEntity extends Internal.BaseContainerBlockEntity implements Internal.InventoryChangeTracker, Internal.SleepingBlockEntity, Internal.WorldlyContainer, Internal.LithiumInventory {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopOpen($$0: Internal.Player_): void;
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        isSleeping(): boolean;
        setChanged(): void;
        onLoad(): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getSlotsForFace($$0: Internal.Direction_): number[];
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setInventoryLithium(arg0: Internal.NonNullList_<any>): void;
        getSleepingTicker(): Internal.TickingBlockEntity;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getInventoryLithium(): Internal.NonNullList<any>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        setTickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        wakeUpNow(): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BrewingStandBlockEntity_): void;
        canTakeItemThroughFace($$0: number, $$1: Internal.ItemStack_, $$2: Internal.Direction_): boolean;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        handler$zgh000$porting_lib_brewing$port_lib$validBrewItem(i: number, itemStack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        canPlaceItemThroughFace($$0: number, $$1: Internal.ItemStack_, $$2: Internal.Direction_): boolean;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        startSleeping(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        setSleepingTicker(sleepingTicker: Internal.TickingBlockEntity_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get sleeping(): boolean
        set inventoryLithium(arg0: Internal.NonNullList_<any>)
        get sleepingTicker(): Internal.TickingBlockEntity
        get inventoryLithium(): Internal.NonNullList<any>
        get width(): number
        get maxStackSize(): number
        set tickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_)
        set ticker(delegate: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        set sleepingTicker(sleepingTicker: Internal.TickingBlockEntity_)
        static readonly FUEL_USES: 20;
        brewTime: number;
        static readonly DATA_BREW_TIME: 0;
        static readonly DATA_FUEL_USES: 1;
        static readonly NUM_DATA_VALUES: 2;
        fuel: number;
    }
    type BrewingStandBlockEntity_ = BrewingStandBlockEntity;
    class DoorBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.BlockSetType_)
        static isWoodenDoor($$0: Internal.BlockState_): boolean;
        static isWoodenDoor($$0: Internal.Level_, $$1: BlockPos_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        setOpen($$0: Internal.Entity_, $$1: Internal.Level_, $$2: Internal.BlockState_, $$3: BlockPos_, $$4: boolean): void;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        type(): Internal.BlockSetType;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        isOpen($$0: Internal.BlockState_): boolean;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
        static readonly OPEN: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
        static readonly HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type DoorBlock_ = DoorBlock;
    class JaggedSandstoneFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(p_67292_: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static placeWeepingVinesColumn(p_225301_: Internal.LevelAccessor_, p_225302_: Internal.RandomSource_, p_225303_: Internal.BlockPos$MutableBlockPos_, p_225304_: number): void;
    }
    type JaggedSandstoneFeature_ = JaggedSandstoneFeature;
    abstract class ShapedBlockBuilder extends Internal.BlockBuilder {
        constructor(i: ResourceLocation_, ...suffixes: string[])
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
    }
    type ShapedBlockBuilder_ = ShapedBlockBuilder;
    interface ISerde {
        abstract serialize(): Internal.JsonObject;
        abstract deserialize(arg0: Internal.JsonObject_): void;
    }
    type ISerde_ = ISerde;
    interface FireBlockHooks {
        abstract fabric_getVanillaEntry(arg0: Internal.BlockState_): Internal.FlammableBlockRegistry$Entry;
        (arg0: Internal.BlockState): Internal.FlammableBlockRegistry$Entry_;
    }
    type FireBlockHooks_ = FireBlockHooks;
    class HammockItem extends Internal.BaseComfortsItem {
        constructor(block: Internal.Block_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HammockItem_ = HammockItem;
    class BakedGlyph$Effect {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number)
    }
    type BakedGlyph$Effect_ = BakedGlyph$Effect;
    class SlimelytraItem extends Internal.SlimesuitItem {
        constructor(material: any_, properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        initializeClient(): void;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        doVanillaElytraTick(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SlimelytraItem_ = SlimelytraItem;
    abstract class AbstractHorizontalFunnelBlock extends Internal.AbstractFunnelBlock {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FunnelBlockEntity>): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FunnelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FunnelBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FunnelBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    }
    type AbstractHorizontalFunnelBlock_ = AbstractHorizontalFunnelBlock;
    interface ExtendedBufferBuilder extends Internal.VertexBufferWriter {
        abstract sodium$getElementOffset(): number;
        tryOf(consumer: Internal.VertexConsumer_): Internal.VertexBufferWriter;
        abstract sodium$moveToNextVertex(): void;
        canUseIntrinsics(): boolean;
        abstract sodium$getBuffer(): Internal.ByteBuffer;
        abstract push(arg0: Internal.MemoryStack_, arg1: number, arg2: number, arg3: Internal.VertexFormatDescription_): void;
        of(consumer: Internal.VertexConsumer_): Internal.VertexBufferWriter;
        copyInto(writer: Internal.VertexBufferWriter_, stack: Internal.MemoryStack_, ptr: number, count: number, format: Internal.VertexFormatDescription_): void;
        abstract sodium$getFormatDescription(): Internal.VertexFormatDescription;
        abstract sodium$getDelegate(): Internal.SodiumBufferBuilder;
        abstract sodium$usingFixedColor(): boolean;
    }
    type ExtendedBufferBuilder_ = ExtendedBufferBuilder;
    interface AccessorToolboxBlockEntity {
        abstract getConnectedPlayers(): Internal.Map<number, Internal.WeakHashMap<Internal.Player, number>>;
        abstract getInventory(): Internal.ToolboxInventory;
        get connectedPlayers(): Internal.Map<number, Internal.WeakHashMap<Internal.Player, number>>
        get inventory(): Internal.ToolboxInventory
    }
    type AccessorToolboxBlockEntity_ = AccessorToolboxBlockEntity;
    interface DoubleCollection extends Internal.DoubleIterable, Internal.Collection<number> {
        abstract add(arg0: number): boolean;
        abstract addAll(arg0: Internal.DoubleCollection_): boolean;
        abstract retainAll(arg0: Internal.DoubleCollection_): boolean;
        abstract containsAll(arg0: Internal.DoubleCollection_): boolean;
        abstract isEmpty(): boolean;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        doubleParallelStream(): Internal.DoubleStream;
        doubleStream(): Internal.DoubleStream;
        abstract toArray(arg0: number[]): number[];
        abstract rem(arg0: number): boolean;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        forEach(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): boolean;
        abstract removeAll(arg0: Internal.DoubleCollection_): boolean;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        abstract contains(arg0: number): boolean;
        /**
         * @deprecated
        */
        toDoubleArray(arg0: number[]): number[];
        doubleIterator(): Internal.DoubleIterator;
        abstract toArray(): any[];
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        abstract size(): number;
        abstract hashCode(): number;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        spliterator(): Internal.Spliterator<any>;
        doubleSpliterator(): Internal.DoubleSpliterator;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract toDoubleArray(): number[];
        abstract clear(): void;
        forEach(arg0: Internal.DoubleConsumer_): void;
        abstract iterator(): Internal.DoubleIterator;
        abstract equals(arg0: any): boolean;
        get empty(): boolean
    }
    type DoubleCollection_ = DoubleCollection;
    interface ReequipAnimationItem {
        shouldCauseReequipAnimation(oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_, slotChanged: boolean): boolean;
    }
    type ReequipAnimationItem_ = ReequipAnimationItem;
    class PunjiBlock extends Internal.Block implements Internal.LandPathNodeTypesRegistry$StaticPathNodeTypeProvider {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPathNodeType(state: Internal.BlockState_, neighbor: boolean): Internal.BlockPathTypes;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type PunjiBlock_ = PunjiBlock;
    class BrassFunnelBlock extends Internal.FunnelBlock {
        constructor(p_i48415_1_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FunnelBlockEntity>): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FunnelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FunnelBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FunnelBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BrassFunnelBlock_ = BrassFunnelBlock;
    abstract class AbstractConstant <T extends Internal.AbstractConstant<T>> implements Internal.Constant<T> {
        name(): string;
        compareTo(arg0: T): number;
        id(): number;
        compareTo(arg0: any): number;
    }
    type AbstractConstant_<T extends Internal.AbstractConstant<T>> = AbstractConstant<T>;
    class SelfDestructiveModifier$SelfDestructiveEffect extends Internal.NoMilkEffect {
        constructor()
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
    }
    type SelfDestructiveModifier$SelfDestructiveEffect_ = SelfDestructiveModifier$SelfDestructiveEffect;
    interface Short2DoubleFunction extends Internal.IntToDoubleFunction, it.unimi.dsi.fastutil.Function<number, number> {
        put(arg0: number, arg1: number): number;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2DoubleFunction;
        apply(arg0: number): number;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2DoubleFunction;
        /**
         * @deprecated
        */
        applyAsDouble(arg0: number): number;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2DoubleFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Short2CharFunction;
        remove(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2DoubleFunction<T>;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2DoubleFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2DoubleFunction<T>;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Short2FloatFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Short2IntFunction;
        containsKey(arg0: number): boolean;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Short2LongFunction;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2DoubleFunction;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2DoubleFunction;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        defaultReturnValue(): number;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Short2ShortFunction;
        size(): number;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        clear(): void;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Short2ByteFunction;
        (arg0: number): number;
    }
    type Short2DoubleFunction_ = Short2DoubleFunction;
    class BlockDragonBoneWall extends Internal.WallBlock implements Internal.IDragonProof {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockDragonBoneWall_ = BlockDragonBoneWall;
    class SmallLightConnectorBlock extends Internal.AbstractConnectorBlock<Internal.SmallLightConnectorBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityClass(): typeof Internal.SmallLightConnectorBlockEntity;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SmallLightConnectorBlockEntity>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SmallLightConnectorBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SmallLightConnectorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SmallLightConnectorBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SmallLightConnectorBlockEntity>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.SmallLightConnectorBlockEntity
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.SmallLightConnectorBlockEntity>
        static readonly CONNECTOR_SHAPE: Internal.VoxelShaper;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type SmallLightConnectorBlock_ = SmallLightConnectorBlock;
    interface WritableRenderedImage extends Internal.RenderedImage {
        abstract setData(arg0: Internal.Raster_): void;
        abstract hasTileWriters(): boolean;
        abstract getSources(): Internal.Vector<Internal.RenderedImage>;
        abstract removeTileObserver(arg0: Internal.TileObserver_): void;
        abstract isTileWritable(arg0: number, arg1: number): boolean;
        abstract releaseWritableTile(arg0: number, arg1: number): void;
        abstract getMinTileX(): number;
        abstract getMinTileY(): number;
        abstract getData(arg0: Internal.Rectangle_): Internal.Raster;
        abstract getData(): Internal.Raster;
        abstract getTileGridYOffset(): number;
        abstract getColorModel(): Internal.ColorModel;
        abstract getTileHeight(): number;
        abstract getTileGridXOffset(): number;
        abstract getProperty(arg0: string): any;
        abstract copyData(arg0: Internal.WritableRaster_): Internal.WritableRaster;
        abstract getMinX(): number;
        abstract getHeight(): number;
        abstract getMinY(): number;
        abstract getWidth(): number;
        abstract addTileObserver(arg0: Internal.TileObserver_): void;
        abstract getSampleModel(): Internal.SampleModel;
        abstract getTile(arg0: number, arg1: number): Internal.Raster;
        abstract getWritableTile(arg0: number, arg1: number): Internal.WritableRaster;
        abstract getWritableTileIndices(): Internal.Point[];
        abstract getPropertyNames(): string[];
        abstract getNumXTiles(): number;
        abstract getNumYTiles(): number;
        abstract getTileWidth(): number;
        set data(arg0: Internal.Raster_)
        get sources(): Internal.Vector<Internal.RenderedImage>
        get minTileX(): number
        get minTileY(): number
        get data(): Internal.Raster
        get tileGridYOffset(): number
        get colorModel(): Internal.ColorModel
        get tileHeight(): number
        get tileGridXOffset(): number
        get minX(): number
        get height(): number
        get minY(): number
        get width(): number
        get sampleModel(): Internal.SampleModel
        get writableTileIndices(): Internal.Point[]
        get propertyNames(): string[]
        get numXTiles(): number
        get numYTiles(): number
        get tileWidth(): number
    }
    type WritableRenderedImage_ = WritableRenderedImage;
    class TurtleBlock extends Internal.AbstractComputerBlock<any> implements Internal.SimpleWaterloggedBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_, type: any_<Internal.BlockEntityType<any>>)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getExplosionResistance(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, explosion: Internal.Explosion_): number;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<U extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<U>): Internal.BlockEntityTicker<U>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly IMMUNE_EXPLOSION_RESISTANCE: 2000.0;
        static readonly FACING: Internal.DirectionProperty;
    }
    type TurtleBlock_ = TurtleBlock;
    class ConstructorInfo {
        constructor(constructor_: Internal.Constructor_<any>)
        getParams(): Internal.List<Internal.MethodInfo$ParamInfo>;
        setParams(params: Internal.List_<Internal.MethodInfo$ParamInfo>): void;
        get params(): Internal.List<Internal.MethodInfo$ParamInfo>
        set params(params: Internal.List_<Internal.MethodInfo$ParamInfo>)
    }
    type ConstructorInfo_ = ConstructorInfo;
    class Raid {
        constructor($$0: Internal.ServerLevel_, $$1: Internal.CompoundTag_)
        constructor($$0: number, $$1: Internal.ServerLevel_, $$2: BlockPos_)
        isVictory(): boolean;
        isOver(): boolean;
        getTotalHealth(): number;
        addHeroOfTheVillage($$0: Internal.Entity_): void;
        removeFromRaid($$0: Internal.Raider_, $$1: boolean): void;
        getGroupsSpawned(): number;
        getMaxBadOmenLevel(): number;
        updateBossbar(): void;
        isStarted(): boolean;
        isActive(): boolean;
        getAllRaiders(): Internal.Set<Internal.Raider>;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        getLevel(): Internal.Level;
        getCenter(): BlockPos;
        static getLeaderBannerInstance(): Internal.ItemStack;
        isLoss(): boolean;
        getHealthOfLivingRaiders(): number;
        removeLeader($$0: number): void;
        isBetweenWaves(): boolean;
        getNumGroups($$0: Internal.Difficulty_): number;
        setLeader($$0: number, $$1: Internal.Raider_): void;
        getId(): number;
        getEnchantOdds(): number;
        setBadOmenLevel($$0: number): void;
        isStopped(): boolean;
        addWaveMob($$0: number, $$1: Internal.Raider_, $$2: boolean): boolean;
        getLeader($$0: number): Internal.Raider;
        tick(): void;
        absorbBadOmen($$0: Internal.Player_): void;
        stop(): void;
        hasFirstWaveSpawned(): boolean;
        getTotalRaidersAlive(): number;
        joinRaid($$0: number, $$1: Internal.Raider_, $$2: BlockPos_, $$3: boolean): void;
        getBadOmenLevel(): number;
        get victory(): boolean
        get over(): boolean
        get totalHealth(): number
        get groupsSpawned(): number
        get maxBadOmenLevel(): number
        get started(): boolean
        get active(): boolean
        get allRaiders(): Internal.Set<Internal.Raider>
        get level(): Internal.Level
        get center(): BlockPos
        get leaderBannerInstance(): Internal.ItemStack
        get loss(): boolean
        get healthOfLivingRaiders(): number
        get betweenWaves(): boolean
        get id(): number
        get enchantOdds(): number
        set badOmenLevel($$0: number)
        get stopped(): boolean
        get totalRaidersAlive(): number
        get badOmenLevel(): number
        static readonly VALID_RAID_RADIUS_SQR: 9216;
        static readonly TICKS_PER_DAY: 24000;
        static readonly MAX_NO_ACTION_TIME: 2400;
        static readonly VILLAGE_RADIUS_BUFFER: 16;
        static readonly DEFAULT_MAX_BAD_OMEN_LEVEL: 5;
        static readonly MAX_CELEBRATION_TICKS: 600;
        static readonly RAID_REMOVAL_THRESHOLD_SQR: 12544;
    }
    type Raid_ = Raid;
    class ModifierSortingRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.ModifierSortingRecipe> {
        constructor()
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.ModifierSortingRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetworkSafe(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        toNetworkSafe(buffer: Internal.FriendlyByteBuf_, recipe: Internal.ModifierSortingRecipe_): void;
        toNetworkSafe(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
    }
    type ModifierSortingRecipe$Serializer_ = ModifierSortingRecipe$Serializer;
    interface Object2ByteFunction <K> extends Internal.ToIntFunction<K>, it.unimi.dsi.fastutil.Function<K, number> {
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Object2IntFunction<K>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        put(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ByteFunction;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ByteFunction;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        removeByte(arg0: any): number;
        apply(arg0: K): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ByteFunction<T>;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ByteFunction;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Object2FloatFunction<K>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ByteFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        applyAsInt(arg0: K): number;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        abstract getByte(arg0: any): number;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Object2ShortFunction<K>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ByteFunction;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ByteFunction<T>;
        clear(): void;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ByteFunction;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ByteFunction;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): number;
    }
    type Object2ByteFunction_<K> = Object2ByteFunction<K>;
    class ConductorWhistleItem extends Internal.TrackTargetingBlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly SPECIAL_MARKER: "<ConductorFlag>";
    }
    type ConductorWhistleItem_ = ConductorWhistleItem;
    class LootContext$EntityTarget extends Internal.Enum<Internal.LootContext$EntityTarget> {
        static getByName($$0: string): Internal.LootContext$EntityTarget;
        static values(): Internal.LootContext$EntityTarget[];
        static valueOf($$0: string): Internal.LootContext$EntityTarget;
        getParam(): Internal.LootContextParam<Internal.Entity>;
        get param(): Internal.LootContextParam<Internal.Entity>
        static readonly KILLER: Internal.LootContext$EntityTarget;
        readonly name: string;
        static readonly THIS: Internal.LootContext$EntityTarget;
        static readonly DIRECT_KILLER: Internal.LootContext$EntityTarget;
        static readonly KILLER_PLAYER: Internal.LootContext$EntityTarget;
    }
    type LootContext$EntityTarget_ = "killer" | LootContext$EntityTarget | "killer_player" | "this" | "direct_killer";
    class DyeableBlockEntity extends Internal.SmartBlockEntity implements Internal.IDyedBuffer {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getColor(): Internal.DyeColor;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        applyDyeIfValid(stack: Internal.ItemStack_): Internal.InteractionResult;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get color(): Internal.DyeColor
        get infiniteBoundingBox(): Internal.AABB
    }
    type DyeableBlockEntity_ = DyeableBlockEntity;
    class ConcurrentHashMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.ConcurrentMap<K, V>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Map_<K, V>)
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        constructor(arg0: number, arg1: number, arg2: number)
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        reduceKeysToDouble(arg0: number, arg1: Internal.ToDoubleFunction_<K>, arg2: number, arg3: Internal.DoubleBinaryOperator_): number;
        keySet(arg0: V): Internal.ConcurrentHashMap$KeySetView<K, V>;
        forEachKey(arg0: number, arg1: Internal.Consumer_<K>): void;
        reduceKeys(arg0: number, arg1: Internal.BiFunction_<K, K, K>): K;
        searchEntries<U>(arg0: number, arg1: Internal.Function_<Internal.Map$Entry<K, V>, U>): U;
        reduceEntries<U>(arg0: number, arg1: Internal.Function_<Internal.Map$Entry<K, V>, U>, arg2: Internal.BiFunction_<U, U, U>): U;
        reduceEntriesToInt(arg0: number, arg1: Internal.ToIntFunction_<Internal.Map$Entry<K, V>>, arg2: number, arg3: Internal.IntBinaryOperator_): number;
        keys(): Internal.Enumeration<K>;
        static newKeySet<K>(): Internal.ConcurrentHashMap$KeySetView<K, boolean>;
        keySet(): Internal.Set<any>;
        reduceValuesToDouble(arg0: number, arg1: Internal.ToDoubleFunction_<V>, arg2: number, arg3: Internal.DoubleBinaryOperator_): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        forEachEntry<U>(arg0: number, arg1: Internal.Function_<Internal.Map$Entry<K, V>, U>, arg2: Internal.Consumer_<U>): void;
        get(arg0: any): V;
        reduceKeys<U>(arg0: number, arg1: Internal.Function_<K, U>, arg2: Internal.BiFunction_<U, U, U>): U;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        putIfAbsent(arg0: K, arg1: V): V;
        reduceToLong(arg0: number, arg1: Internal.ToLongBiFunction_<K, V>, arg2: number, arg3: Internal.LongBinaryOperator_): number;
        forEachKey<U>(arg0: number, arg1: Internal.Function_<K, U>, arg2: Internal.Consumer_<U>): void;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        reduceValuesToInt(arg0: number, arg1: Internal.ToIntFunction_<V>, arg2: number, arg3: Internal.IntBinaryOperator_): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        forEachEntry(arg0: number, arg1: Internal.Consumer_<Internal.Map$Entry<K, V>>): void;
        reduceEntriesToDouble(arg0: number, arg1: Internal.ToDoubleFunction_<Internal.Map$Entry<K, V>>, arg2: number, arg3: Internal.DoubleBinaryOperator_): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        reduceEntriesToLong(arg0: number, arg1: Internal.ToLongFunction_<Internal.Map$Entry<K, V>>, arg2: number, arg3: Internal.LongBinaryOperator_): number;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        reduceKeysToLong(arg0: number, arg1: Internal.ToLongFunction_<K>, arg2: number, arg3: Internal.LongBinaryOperator_): number;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V): V;
        forEach<U>(arg0: number, arg1: Internal.BiFunction_<K, V, U>, arg2: Internal.Consumer_<U>): void;
        mappingCount(): number;
        reduceToDouble(arg0: number, arg1: Internal.ToDoubleBiFunction_<K, V>, arg2: number, arg3: Internal.DoubleBinaryOperator_): number;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        reduceKeysToInt(arg0: number, arg1: Internal.ToIntFunction_<K>, arg2: number, arg3: Internal.IntBinaryOperator_): number;
        reduceValuesToLong(arg0: number, arg1: Internal.ToLongFunction_<V>, arg2: number, arg3: Internal.LongBinaryOperator_): number;
        put(arg0: K, arg1: V): V;
        reduceToInt(arg0: number, arg1: Internal.ToIntBiFunction_<K, V>, arg2: number, arg3: Internal.IntBinaryOperator_): number;
        static newKeySet<K>(arg0: number): Internal.ConcurrentHashMap$KeySetView<K, boolean>;
        remove(arg0: any): V;
        contains(arg0: any): boolean;
        elements(): Internal.Enumeration<V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        forEachValue<U>(arg0: number, arg1: Internal.Function_<V, U>, arg2: Internal.Consumer_<U>): void;
        forEachValue(arg0: number, arg1: Internal.Consumer_<V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        reduceValues(arg0: number, arg1: Internal.BiFunction_<V, V, V>): V;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        reduceEntries(arg0: number, arg1: Internal.BiFunction_<Internal.Map$Entry<K, V>, Internal.Map$Entry<K, V>, Internal.Map$Entry<K, V>>): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        search<U>(arg0: number, arg1: Internal.BiFunction_<K, V, U>): U;
        reduceValues<U>(arg0: number, arg1: Internal.Function_<V, U>, arg2: Internal.BiFunction_<U, U, U>): U;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        searchKeys<U>(arg0: number, arg1: Internal.Function_<K, U>): U;
        searchValues<U>(arg0: number, arg1: Internal.Function_<V, U>): U;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        forEach(arg0: number, arg1: Internal.BiConsumer_<K, V>): void;
        reduce<U>(arg0: number, arg1: Internal.BiFunction_<K, V, U>, arg2: Internal.BiFunction_<U, U, U>): U;
    }
    type ConcurrentHashMap_<K, V> = ConcurrentHashMap<K, V>;
    interface BuilderCallback {
        abstract accept<R, T extends R>(arg0: string, arg1: Internal.ResourceKey_<Internal.Registry<R>>, arg2: Internal.Builder_<R, T, any, any>, arg3: Internal.NonNullSupplier_<T>, arg4: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.RegistryObject<T>, Internal.RegistryEntry<T>>): Internal.RegistryEntry<T>;
        accept<R, T extends R>(name: string, type: Internal.ResourceKey_<Internal.Registry<R>>, builder: Internal.Builder_<R, T, any, any>, factory: Internal.NonNullSupplier_<T>): Internal.RegistryEntry<T>;
        (arg0: string, arg1: Internal.ResourceKey<Internal.Registry<R>>, arg2: Internal.Builder<R, T, any, any>, arg3: Internal.NonNullSupplier<T>, arg4: com.tterrag.registrate.util.nullness.NonNullFunction<Internal.RegistryObject<T>, Internal.RegistryEntry<T>>): Internal.RegistryEntry_<T>;
    }
    type BuilderCallback_ = BuilderCallback;
    interface IWorldUpdateSuppressor {
        abstract litematica_setShouldPreventBlockUpdates(arg0: boolean): void;
        abstract litematica_getShouldPreventBlockUpdates(): boolean;
    }
    type IWorldUpdateSuppressor_ = IWorldUpdateSuppressor;
    class ResultField implements Internal.Comparable<Internal.ResultField> {
        constructor($$0: string, $$1: number, $$2: number, $$3: number)
        getColor(): number;
        compareTo($$0: Internal.ResultField_): number;
        compareTo(arg0: any): number;
        get color(): number
        readonly percentage: number;
        readonly globalPercentage: number;
        readonly name: string;
        readonly count: number;
    }
    type ResultField_ = ResultField;
    class Cow extends Internal.Animal {
        constructor($$0: Internal.EntityType_<Internal.Cow>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        handler$eok000$milk$interactMob(player: Internal.Player_, hand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Cow_ = Cow;
    class SandPaperItem extends Internal.Item implements Internal.CustomUseEffectsItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static spawnParticles(location: Vec3d_, polishedStack: Internal.ItemStack_, world: Internal.Level_): void;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        shouldTriggerUseEffects(stack: Internal.ItemStack_, entity: Internal.LivingEntity_): net.createmod.catnip.data.TriState;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        triggerUseEffects(stack: Internal.ItemStack_, entity: Internal.LivingEntity_, count: number, random: Internal.RandomSource_): boolean;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SandPaperItem_ = SandPaperItem;
    interface IWallBlock {
        abstract wallBlock(): Internal.Block;
        (): Internal.Block_;
    }
    type IWallBlock_ = IWallBlock;
    class RefillUpgradeWrapper$TargetSlot extends Internal.Enum<Internal.RefillUpgradeWrapper$TargetSlot> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        getAcronym(): net.minecraft.network.chat.Component;
        static valueOf(name: string): Internal.RefillUpgradeWrapper$TargetSlot;
        next(): this;
        previous(): this;
        static fromName(name: string): Internal.RefillUpgradeWrapper$TargetSlot;
        static values(): Internal.RefillUpgradeWrapper$TargetSlot[];
        getDescription(): net.minecraft.network.chat.Component;
        get serializedName(): string
        get acronym(): net.minecraft.network.chat.Component
        get description(): net.minecraft.network.chat.Component
        static readonly TOOLBAR_3: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_2: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_1: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_7: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_6: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly OFF_HAND: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_5: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_4: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_9: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly TOOLBAR_8: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly ANY: Internal.RefillUpgradeWrapper$TargetSlot;
        static readonly MAIN_HAND: Internal.RefillUpgradeWrapper$TargetSlot;
    }
    type RefillUpgradeWrapper$TargetSlot_ = "off_hand" | "toolbar_3" | RefillUpgradeWrapper$TargetSlot | "toolbar_4" | "toolbar_1" | "toolbar_2" | "toolbar_7" | "toolbar_8" | "toolbar_5" | "toolbar_6" | "main_hand" | "toolbar_9" | "any";
    class CreativeTabEvent extends Internal.EventJS {
        constructor(tab: Internal.CreativeModeTab_, showRestrictedItems: boolean, callback: any_)
        add(items: Internal.ItemStack_[]): void;
        setDisplayName(component: net.minecraft.network.chat.Component_): void;
        setIcon(icon: Internal.ItemStack_): void;
        addAfter(order: Internal.ItemStack_, items: Internal.ItemStack_[], visibility: Internal.CreativeModeTab$TabVisibility_): void;
        addAfter(order: Internal.ItemStack_, items: Internal.ItemStack_[]): void;
        remove(filter: Internal.Ingredient_): void;
        add(items: Internal.ItemStack_[], visibility: Internal.CreativeModeTab$TabVisibility_): void;
        removeDisplay(filter: Internal.Ingredient_): void;
        addBefore(order: Internal.ItemStack_, items: Internal.ItemStack_[]): void;
        removeSearch(filter: Internal.Ingredient_): void;
        addBefore(order: Internal.ItemStack_, items: Internal.ItemStack_[], visibility: Internal.CreativeModeTab$TabVisibility_): void;
        set displayName(component: net.minecraft.network.chat.Component_)
        set icon(icon: Internal.ItemStack_)
        readonly showRestrictedItems: boolean;
        readonly tab: Internal.CreativeModeTab;
    }
    type CreativeTabEvent_ = CreativeTabEvent;
    class Slot implements Internal.SlotAccessor, earth.terrarium.adastra.mixins.common.SlotAccessor, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.SlotAccessor, Internal.SophisticatedSlot, net.p3pp3rf1y.sophisticatedcore.mixin.common.accessor.SlotAccessor, Internal.BigSlot, Internal.OwoSlotExtension, net.blay09.mods.balm.mixin.SlotAccessor, Internal.SlotExtensions {
        constructor($$0: net.minecraft.world.Container_, $$1: number, $$2: number, $$3: number)
        onTake($$0: Internal.Player_, $$1: Internal.ItemStack_): void;
        allowModification($$0: Internal.Player_): boolean;
        set($$0: Internal.ItemStack_): void;
        tryRemove($$0: number, $$1: number, $$2: Internal.Player_): Internal.Optional<Internal.ItemStack>;
        setByPlayer($$0: Internal.ItemStack_): void;
        owo$getScissorArea(): Internal.PositionedRectangle;
        isBigSlot(): boolean;
        isActive(): boolean;
        getItemVariant(): Internal.ItemVariant;
        sophisticatedcore$setBackground(atlas: ResourceLocation_, sprite: ResourceLocation_): this;
        port_lib$getSlotIndex(): number;
        setChanged(): void;
        setY(arg0: number): void;
        setX(arg0: number): void;
        hasItem(): boolean;
        safeTake($$0: number, $$1: number, $$2: Internal.Player_): Internal.ItemStack;
        getSlotIndex(): number;
        setBackground(atlas: ResourceLocation_, sprite: ResourceLocation_): this;
        isHighlightable(): boolean;
        safeInsert($$0: Internal.ItemStack_): Internal.ItemStack;
        callOnSwapCraft(arg0: number): void;
        getMaxStackSize(): number;
        getItem(): Internal.ItemStack;
        isSameInventory(other: Internal.Slot_): boolean;
        setBigSlot(bigSlot: boolean): this;
        owo$setScissorArea(scissor: Internal.PositionedRectangle_): void;
        mayPickup($$0: Internal.Player_): boolean;
        owo$setY(arg0: number): void;
        remove($$0: number): Internal.ItemStack;
        owo$setX(arg0: number): void;
        getMaxStackSize($$0: Internal.ItemStack_): number;
        mayPlace($$0: Internal.ItemStack_): boolean;
        owo$setDisabledOverride(disabled: boolean): void;
        owo$getDisabledOverride(): boolean;
        onQuickCraft($$0: Internal.ItemStack_, $$1: Internal.ItemStack_): void;
        getNoItemIcon(): com.mojang.datafixers.util.Pair<ResourceLocation, ResourceLocation>;
        safeInsert($$0: Internal.ItemStack_, $$1: number): Internal.ItemStack;
        getContainerSlot(): number;
        set byPlayer($$0: Internal.ItemStack_)
        get bigSlot(): boolean
        get active(): boolean
        get itemVariant(): Internal.ItemVariant
        set y(arg0: number)
        set x(arg0: number)
        get slotIndex(): number
        get highlightable(): boolean
        get maxStackSize(): number
        get item(): Internal.ItemStack
        set bigSlot(bigSlot: boolean)
        get noItemIcon(): com.mojang.datafixers.util.Pair<ResourceLocation, ResourceLocation>
        get containerSlot(): number
        index: number;
        x: number;
        y: number;
        readonly slot: number;
        readonly container: net.minecraft.world.Container;
    }
    type Slot_ = Slot;
    class Blender {
        getBiomeResolver($$0: Internal.BiomeResolver_): Internal.BiomeResolver;
        static generateBorderTicks($$0: Internal.WorldGenRegion_, $$1: Internal.ChunkAccess_): void;
        blendOffsetAndFactor($$0: number, $$1: number): Internal.Blender$BlendingOutput;
        blendDensity($$0: Internal.DensityFunction$FunctionContext_, $$1: number): number;
        static empty(): Internal.Blender;
        static makeOldChunkDistanceGetter($$0: Internal.BlendingData_, $$1: Internal.Map_<Internal.Direction8, Internal.BlendingData>): Internal.Blender$DistanceGetter;
        static addAroundOldChunksCarvingMaskFilter($$0: Internal.WorldGenLevel_, $$1: Internal.ProtoChunk_): void;
        static of($$0: Internal.WorldGenRegion_): Internal.Blender;
    }
    type Blender_ = Blender;
    class SlimeFungusFeature extends Internal.HugeFungusFeature {
        constructor(codec: Internal.Codec_<Internal.HugeFungusConfiguration>)
    }
    type SlimeFungusFeature_ = SlimeFungusFeature;
    class BlendedNoise implements Internal.DensityFunction$SimpleFunction {
        constructor($$0: Internal.RandomSource_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number)
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        withNewRandom($$0: Internal.RandomSource_): this;
        maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute($$0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        static createUnseeded($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): Internal.BlendedNoise;
        square(): Internal.DensityFunction;
        parityConfigString($$0: Internal.StringBuilder_): void;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.BlendedNoise>;
    }
    type BlendedNoise_ = BlendedNoise;
    class Cod extends Internal.AbstractSchoolingFish {
        constructor($$0: Internal.EntityType_<Internal.Cod>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        /**
         * @deprecated
        */
        static loadDefaultDataFromBucketTag($$0: Internal.Mob_, $$1: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        /**
         * @deprecated
        */
        static saveDefaultDataToBucketTag($$0: Internal.Mob_, $$1: Internal.ItemStack_): void;
        getScriptType(): Internal.ScriptType;
        static bucketMobPickup<T extends Internal.LivingEntity & Internal.Bucketable>($$0: Internal.Player_, $$1: Internal.InteractionHand_, $$2: T): Internal.Optional<Internal.InteractionResult>;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Cod_ = Cod;
    class PumpUpgradeItem extends Internal.UpgradeItemBase<Internal.PumpUpgradeWrapper> {
        constructor(interactWithHandDefault: boolean, interactWithWorldDefault: boolean, pumpUpgradeConfig: Internal.PumpUpgradeConfig_, upgradeTypeLimitConfig: any_)
        getType(): Internal.UpgradeType<Internal.PumpUpgradeWrapper>;
        getInteractWithHandDefault(): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getInventoryColumnsTaken(): number;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getInteractWithWorldDefault(): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getPumpUpgradeConfig(): Internal.PumpUpgradeConfig;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        get type(): Internal.UpgradeType<Internal.PumpUpgradeWrapper>
        get interactWithHandDefault(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get inventoryColumnsTaken(): number
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get interactWithWorldDefault(): boolean
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get pumpUpgradeConfig(): Internal.PumpUpgradeConfig
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type PumpUpgradeItem_ = PumpUpgradeItem;
    class BoundingBox {
        constructor($$0: BlockPos_)
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number)
        forAllCorners($$0: Internal.Consumer_<BlockPos>): void;
        static encapsulatingPositions($$0: Internal.Iterable_<BlockPos>): Internal.Optional<Internal.BoundingBox>;
        getXSpan(): number;
        maxY(): number;
        maxX(): number;
        getCenter(): BlockPos;
        static fromCorners($$0: Vec3i_, $$1: Vec3i_): Internal.BoundingBox;
        maxZ(): number;
        isInside($$0: number, $$1: number, $$2: number): boolean;
        isInside($$0: Vec3i_): boolean;
        static encapsulatingBoxes($$0: Internal.Iterable_<Internal.BoundingBox>): Internal.Optional<Internal.BoundingBox>;
        intersects($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getYSpan(): number;
        intersects($$0: Internal.BoundingBox_): boolean;
        /**
         * @deprecated
        */
        encapsulate($$0: BlockPos_): this;
        moved($$0: number, $$1: number, $$2: number): this;
        static orientBox($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: Internal.Direction_): Internal.BoundingBox;
        getLength(): Vec3i;
        minZ(): number;
        minY(): number;
        static infinite(): Internal.BoundingBox;
        minX(): number;
        /**
         * @deprecated
        */
        move($$0: number, $$1: number, $$2: number): this;
        inflatedBy($$0: number): this;
        getZSpan(): number;
        /**
         * @deprecated
        */
        move($$0: Vec3i_): this;
        /**
         * @deprecated
        */
        encapsulate($$0: Internal.BoundingBox_): this;
        get XSpan(): number
        get center(): BlockPos
        get YSpan(): number
        get length(): Vec3i
        get ZSpan(): number
        static readonly CODEC: Internal.Codec<Internal.BoundingBox>;
    }
    type BoundingBox_ = BoundingBox;
    class ServerboundRecipeBookChangeSettingsPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.RecipeBookType_, $$1: boolean, $$2: boolean)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getBookType(): Internal.RecipeBookType;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isOpen(): boolean;
        isFiltering(): boolean;
        isSkippable(): boolean;
        get bookType(): Internal.RecipeBookType
        get open(): boolean
        get filtering(): boolean
        get skippable(): boolean
    }
    type ServerboundRecipeBookChangeSettingsPacket_ = ServerboundRecipeBookChangeSettingsPacket;
    class WorldCreationUiState$SelectedGameMode extends Internal.Enum<Internal.WorldCreationUiState$SelectedGameMode> {
        static valueOf($$0: string): Internal.WorldCreationUiState$SelectedGameMode;
        getInfo(): net.minecraft.network.chat.Component;
        static values(): Internal.WorldCreationUiState$SelectedGameMode[];
        get info(): net.minecraft.network.chat.Component
        readonly displayName: net.minecraft.network.chat.Component;
        static readonly SURVIVAL: Internal.WorldCreationUiState$SelectedGameMode;
        static readonly DEBUG: Internal.WorldCreationUiState$SelectedGameMode;
        readonly gameType: Internal.GameType;
        static readonly CREATIVE: Internal.WorldCreationUiState$SelectedGameMode;
        static readonly HARDCORE: Internal.WorldCreationUiState$SelectedGameMode;
    }
    type WorldCreationUiState$SelectedGameMode_ = "hardcore" | "debug" | WorldCreationUiState$SelectedGameMode | "survival" | "creative";
    class GossipType extends Internal.Enum<Internal.GossipType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.GossipType;
        getSerializedName(): string;
        static values(): Internal.GossipType[];
        get serializedName(): string
        readonly decayPerDay: number;
        static readonly MINOR_POSITIVE: Internal.GossipType;
        static readonly REPUTATION_CHANGE_PER_EVENT: 25;
        readonly weight: number;
        static readonly TRADING: Internal.GossipType;
        static readonly REPUTATION_CHANGE_PER_EVERLASTING_MEMORY: 20;
        static readonly MINOR_NEGATIVE: Internal.GossipType;
        static readonly MAJOR_NEGATIVE: Internal.GossipType;
        static readonly REPUTATION_CHANGE_PER_TRADE: 2;
        readonly id: string;
        readonly decayPerTransfer: number;
        static readonly MAJOR_POSITIVE: Internal.GossipType;
        static readonly CODEC: Internal.Codec<Internal.GossipType>;
        readonly max: number;
    }
    type GossipType_ = GossipType | "major_positive" | "minor_negative" | "major_negative" | "trading" | "minor_positive";
    class AlloyerBlock extends Internal.TinyMultiblockControllerBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, wanted: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type AlloyerBlock_ = AlloyerBlock;
    interface DrawCallTrackingRenderBuffers {
        abstract getRenderTypes(): number;
        abstract resetDrawCounts(): void;
        abstract getDrawCalls(): number;
        get renderTypes(): number
        get drawCalls(): number
    }
    type DrawCallTrackingRenderBuffers_ = DrawCallTrackingRenderBuffers;
    class EnergizerBlock extends Internal.MachineBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWER: Internal.IntegerProperty;
    }
    type EnergizerBlock_ = EnergizerBlock;
    class MagmatorBlock extends Internal.AbstractGeneratorBlock<Internal.MagmatorBlock> {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        getConfig(): any;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get config(): any
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MagmatorBlock_ = MagmatorBlock;
    class DreadwoodSaplingBlock extends Internal.SaplingBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type DreadwoodSaplingBlock_ = DreadwoodSaplingBlock;
    class SoundKeyframeEvent <T extends Internal.GeoAnimatable> extends Internal.KeyFrameEvent<T, Internal.SoundKeyframeData> {
        constructor(entity: T, animationTick: number, controller: Internal.AnimationController_<T>, keyFrameData: Internal.SoundKeyframeData_)
        getKeyframeData(): Internal.SoundKeyframeData;
        get keyframeData(): Internal.SoundKeyframeData
    }
    type SoundKeyframeEvent_<T extends Internal.GeoAnimatable> = SoundKeyframeEvent<T>;
    class CookingPotRecipe implements Internal.Recipe<Internal.RecipeWrapper> {
        constructor(id: ResourceLocation_, group: string, tab: Internal.CookingPotRecipeBookTab_, inputItems: Internal.NonNullList_<Internal.Ingredient>, output: Internal.ItemStack_, container: Internal.ItemStack_, experience: number, cookTime: number)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        matches(inv: Internal.RecipeWrapper_, level: Internal.Level_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getExperience(): number;
        isSpecial(): boolean;
        assemble(inv: Internal.RecipeWrapper_, access: Internal.RegistryAccess_): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(width: number, height: number): boolean;
        getRemainingItems($$0: Internal.RecipeWrapper_): Internal.NonNullList<Internal.ItemStack>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getCookTime(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        getRecipeBookTab(): Internal.CookingPotRecipeBookTab;
        getOutputContainer(): Internal.ItemStack;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get experience(): number
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get cookTime(): number
        get orCreateId(): ResourceLocation
        get recipeBookTab(): Internal.CookingPotRecipeBookTab
        get outputContainer(): Internal.ItemStack
        get incomplete(): boolean
        static readonly INPUT_SLOTS: 6;
    }
    type CookingPotRecipe_ = CookingPotRecipe;
    interface Int2ObjectMap$Entry <V> extends Internal.Map$Entry<number, V> {
        comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract hashCode(): number;
        copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract getIntKey(): number;
        abstract getValue(): V;
        /**
         * @deprecated
        */
        getKey(): number;
        comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract equals(arg0: any): boolean;
        abstract setValue(arg0: V): V;
        get intKey(): number
        get value(): V
        /**
         * @deprecated
        */
        get key(): number
        set value(arg0: V)
    }
    type Int2ObjectMap$Entry_<V> = Int2ObjectMap$Entry<V>;
    class BufferBuilder extends Internal.DefaultedVertexConsumer implements Internal.ExtendedBufferBuilder, Internal.OwoBufferBuilderExtension, Internal.BufferBuilderExt, Internal.VertexBufferWriter, Internal.IrisExtendedBufferBuilder, Internal.BufferVertexConsumer, Internal.IBufferBuilder, Internal.MemoryTrackingBuffer, Internal.ETFVertexConsumer, Internal.ExtendingBufferBuilder, Internal.BufferBuilderAccessor, Internal.BlockSensitiveBufferBuilder {
        constructor($$0: number)
        uv2($$0: number): Internal.VertexConsumer;
        static normalIntValue($$0: number): number;
        etf$getProvider(): Internal.MultiBufferSource;
        normal($$0: number, $$1: number, $$2: number): Internal.VertexConsumer;
        begin($$0: Internal.VertexFormat$Mode_, $$1: Internal.VertexFormat_): void;
        catnip$getVertices(): number;
        etf$initETFVertexConsumer(provider: Internal.MultiBufferSource_, renderLayer: Internal.RenderType_): void;
        getSortState(): Internal.BufferBuilder$SortState;
        sodium$getBuffer(): Internal.ByteBuffer;
        iris$currentLocalPosZ(): number;
        getUsedSize(): number;
        iris$format(): Internal.VertexFormat;
        sodium$getFormatDescription(): Internal.VertexFormatDescription;
        sodium$usingFixedColor(): boolean;
        iris$currentLocalPosX(): number;
        currentElement(): Internal.VertexFormatElement;
        static tryOf(consumer: Internal.VertexConsumer_): Internal.VertexBufferWriter;
        localvar$dni000$iris$vertex(alpha: number): number;
        canUseIntrinsics(): boolean;
        overlayCoords($$0: number, $$1: number): Internal.VertexConsumer;
        endBlock(): void;
        building(): boolean;
        owo$skipNextBegin(): void;
        getAllocatedSize(): number;
        uvShort($$0: number, $$1: number, $$2: number): Internal.VertexConsumer;
        iris$injectNormalAndUV1(): boolean;
        iris$incrementVertexCount(): void;
        putByte($$0: number, $$1: number): void;
        normal(matrix: Matrix3f_, x: number, y: number, z: number): Internal.VertexConsumer;
        putFloat($$0: number, $$1: number): void;
        etf$getETFTexture(): Internal.ETFTexture;
        iris$currentBlock(): number;
        sodium$getElementOffset(): number;
        color($$0: number): Internal.VertexConsumer;
        end(): Internal.BufferBuilder$RenderedBuffer;
        isCurrentBatchEmpty(): boolean;
        etf$getRenderLayer(): Internal.RenderType;
        static of(consumer: Internal.VertexConsumer_): Internal.VertexBufferWriter;
        sodium$getDelegate(): Internal.SodiumBufferBuilder;
        immediatelyFast$release(): void;
        restoreSortState($$0: Internal.BufferBuilder$SortState_): void;
        iris$vertexCount(): number;
        freeAndDeleteBuffer(): void;
        overlayCoords($$0: number): Internal.VertexConsumer;
        endOrDiscardIfEmpty(): Internal.BufferBuilder$RenderedBuffer;
        vertex($$0: number, $$1: number, $$2: number): Internal.VertexConsumer;
        setQuadSorting($$0: Internal.VertexSorting_): void;
        color($$0: number, $$1: number, $$2: number, $$3: number): Internal.VertexConsumer;
        iris$beginWithoutExtending(drawMode: Internal.VertexFormat$Mode_, vertexFormat: Internal.VertexFormat_): void;
        iris$currentLocalPosY(): number;
        sodium$moveToNextVertex(): void;
        iris$currentRenderType(): number;
        nextElement(): void;
        static copyInto(writer: Internal.VertexBufferWriter_, stack: Internal.MemoryStack_, ptr: number, count: number, format: Internal.VertexFormatDescription_): void;
        putShort($$0: number, $$1: number): void;
        immediatelyFast$isReleased(): boolean;
        iris$resetVertexCount(): void;
        iris$mode(): Internal.VertexFormat$Mode;
        clear(): void;
        splitStrip(): void;
        discard(): void;
        vertex(matrix: Matrix4f_, x: number, y: number, z: number): Internal.VertexConsumer;
        push(stack: Internal.MemoryStack_, src: number, count: number, format: Internal.VertexFormatDescription_): void;
        uv($$0: number, $$1: number): Internal.VertexConsumer;
        iris$extending(): boolean;
        beginBlock(block: number, renderType: number, localPosX: number, localPosY: number, localPosZ: number): void;
        iris$isTerrain(): boolean;
        get sortState(): Internal.BufferBuilder$SortState
        get usedSize(): number
        get allocatedSize(): number
        get currentBatchEmpty(): boolean
        set quadSorting($$0: Internal.VertexSorting_)
        format: Internal.VertexFormat;
    }
    type BufferBuilder_ = BufferBuilder;
    class KelpFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type KelpFeature_ = KelpFeature;
    class CompletableFuture <T> implements Internal.Future<T>, Internal.CompletionStage<T> {
        constructor()
        exceptionallyComposeAsync(arg0: Internal.Function_<Internal.Throwable, Internal.CompletionStage<T>>, arg1: Internal.Executor_): this;
        getNow(arg0: T): T;
        thenAcceptAsync(arg0: Internal.Consumer_<any>, arg1: Internal.Executor_): Internal.CompletionStage<any>;
        static delayedExecutor(arg0: number, arg1: Internal.TimeUnit_): Internal.Executor;
        exceptionallyAsync(arg0: Internal.Function_<any, any>): Internal.CompletionStage<any>;
        acceptEither(arg0: Internal.CompletionStage_<T>, arg1: Internal.Consumer_<T>): Internal.CompletableFuture<void>;
        thenAcceptAsync(arg0: Internal.Consumer_<any>): Internal.CompletionStage<any>;
        applyToEitherAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.Function_<any, any>, arg2: Internal.Executor_): Internal.CompletionStage<any>;
        thenApplyAsync(arg0: Internal.Function_<any, any>): Internal.CompletionStage<any>;
        exceptionallyAsync(arg0: Internal.Function_<Internal.Throwable, T>, arg1: Internal.Executor_): this;
        exceptionallyComposeAsync(arg0: Internal.Function_<Internal.Throwable, Internal.CompletionStage<T>>): this;
        complete(arg0: T): boolean;
        completeAsync(arg0: Internal.Supplier_<T>): this;
        thenComposeAsync(arg0: Internal.Function_<any, any>, arg1: Internal.Executor_): Internal.CompletionStage<any>;
        handleAsync<U>(arg0: Internal.BiFunction_<T, Internal.Throwable, U>): Internal.CompletableFuture<U>;
        get(): T;
        thenRun(arg0: Internal.Runnable_): Internal.CompletableFuture<void>;
        runAfterEitherAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.Runnable_, arg2: Internal.Executor_): Internal.CompletionStage<any>;
        isCancelled(): boolean;
        acceptEitherAsync(arg0: Internal.CompletionStage_<T>, arg1: Internal.Consumer_<T>, arg2: Internal.Executor_): Internal.CompletableFuture<void>;
        thenCombineAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.BiFunction_<any, any, any>, arg2: Internal.Executor_): Internal.CompletionStage<any>;
        resultNow(): T;
        thenRunAsync(arg0: Internal.Runnable_, arg1: Internal.Executor_): Internal.CompletionStage<any>;
        whenCompleteAsync(arg0: Internal.BiConsumer_<any, any>, arg1: Internal.Executor_): Internal.CompletionStage<any>;
        runAfterEitherAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.Runnable_): Internal.CompletionStage<any>;
        exceptionally(arg0: Internal.Function_<any, any>): Internal.CompletionStage<any>;
        thenAcceptBoth(arg0: Internal.CompletionStage_<any>, arg1: Internal.BiConsumer_<any, any>): Internal.CompletionStage<any>;
        static delayedExecutor(arg0: number, arg1: Internal.TimeUnit_, arg2: Internal.Executor_): Internal.Executor;
        static failedFuture<U>(arg0: Internal.Throwable_): Internal.CompletableFuture<U>;
        static runAsync(arg0: Internal.Runnable_, arg1: Internal.Executor_): Internal.CompletableFuture<void>;
        cancel(arg0: boolean): boolean;
        static runAsync(arg0: Internal.Runnable_): Internal.CompletableFuture<void>;
        runAfterBoth(arg0: Internal.CompletionStage_<any>, arg1: Internal.Runnable_): Internal.CompletionStage<any>;
        runAfterEither(arg0: Internal.CompletionStage_<any>, arg1: Internal.Runnable_): Internal.CompletionStage<any>;
        runAfterBothAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.Runnable_): Internal.CompletableFuture<void>;
        join(): T;
        orTimeout(arg0: number, arg1: Internal.TimeUnit_): this;
        thenRunAsync(arg0: Internal.Runnable_): Internal.CompletionStage<any>;
        thenAcceptBothAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.BiConsumer_<any, any>): Internal.CompletionStage<any>;
        static supplyAsync<U>(arg0: Internal.Supplier_<U>, arg1: Internal.Executor_): Internal.CompletableFuture<U>;
        minimalCompletionStage(): Internal.CompletionStage<T>;
        get(arg0: number, arg1: Internal.TimeUnit_): T;
        acceptEitherAsync(arg0: Internal.CompletionStage_<T>, arg1: Internal.Consumer_<T>): Internal.CompletableFuture<void>;
        isCompletedExceptionally(): boolean;
        static supplyAsync<U>(arg0: Internal.Supplier_<U>): Internal.CompletableFuture<U>;
        thenCombineAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.BiFunction_<any, any, any>): Internal.CompletionStage<any>;
        copy(): this;
        static completedFuture<U>(arg0: U): Internal.CompletableFuture<U>;
        completeExceptionally(arg0: Internal.Throwable_): boolean;
        obtrudeException(arg0: Internal.Throwable_): void;
        applyToEither(arg0: Internal.CompletionStage_<any>, arg1: Internal.Function_<any, any>): Internal.CompletionStage<any>;
        static completedStage<U>(arg0: U): Internal.CompletionStage<U>;
        runAfterBothAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.Runnable_, arg2: Internal.Executor_): Internal.CompletionStage<any>;
        thenAccept(arg0: Internal.Consumer_<T>): Internal.CompletableFuture<void>;
        handle(arg0: Internal.BiFunction_<any, any, any>): Internal.CompletionStage<any>;
        exceptionNow(): Internal.Throwable;
        thenAcceptBothAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.BiConsumer_<any, any>, arg2: Internal.Executor_): Internal.CompletionStage<any>;
        thenCompose<U>(arg0: Internal.Function_<T, Internal.CompletionStage<U>>): Internal.CompletableFuture<U>;
        handleAsync(arg0: Internal.BiFunction_<any, any, any>, arg1: Internal.Executor_): Internal.CompletionStage<any>;
        static anyOf(...arg0: Internal.CompletableFuture_<any>[]): Internal.CompletableFuture<any>;
        state(): Internal.Future$State;
        completeOnTimeout(arg0: T, arg1: number, arg2: Internal.TimeUnit_): this;
        newIncompleteFuture<U>(): Internal.CompletableFuture<U>;
        static failedStage<U>(arg0: Internal.Throwable_): Internal.CompletionStage<U>;
        defaultExecutor(): Internal.Executor;
        whenCompleteAsync(arg0: Internal.BiConsumer_<any, any>): Internal.CompletionStage<any>;
        obtrudeValue(arg0: T): void;
        thenComposeAsync<U>(arg0: Internal.Function_<T, Internal.CompletionStage<U>>): Internal.CompletableFuture<U>;
        getNumberOfDependents(): number;
        isDone(): boolean;
        thenCombine<U, V>(arg0: Internal.CompletionStage_<U>, arg1: Internal.BiFunction_<T, U, V>): Internal.CompletableFuture<V>;
        static allOf(...arg0: Internal.CompletableFuture_<any>[]): Internal.CompletableFuture<void>;
        thenApply(arg0: Internal.Function_<any, any>): Internal.CompletionStage<any>;
        toCompletableFuture(): this;
        exceptionallyCompose(arg0: Internal.Function_<Internal.Throwable, Internal.CompletionStage<T>>): this;
        thenApplyAsync(arg0: Internal.Function_<any, any>, arg1: Internal.Executor_): Internal.CompletionStage<any>;
        applyToEitherAsync(arg0: Internal.CompletionStage_<any>, arg1: Internal.Function_<any, any>): Internal.CompletionStage<any>;
        whenComplete(arg0: Internal.BiConsumer_<T, Internal.Throwable>): this;
        completeAsync(arg0: Internal.Supplier_<T>, arg1: Internal.Executor_): this;
        get cancelled(): boolean
        get completedExceptionally(): boolean
        get numberOfDependents(): number
        get done(): boolean
    }
    type CompletableFuture_<T> = CompletableFuture<T>;
    class Cipher {
        wrap(arg0: Internal.Key_): number[];
        update(arg0: number[], arg1: number, arg2: number, arg3: number[]): number;
        doFinal(arg0: number[], arg1: number): number;
        doFinal(): number[];
        update(arg0: number[]): number[];
        doFinal(arg0: number[]): number[];
        doFinal(arg0: number[], arg1: number, arg2: number, arg3: number[]): number;
        getParameters(): Internal.AlgorithmParameters;
        getAlgorithm(): string;
        doFinal(arg0: number[], arg1: number, arg2: number): number[];
        init(arg0: number, arg1: Internal.Key_): void;
        init(arg0: number, arg1: Internal.Certificate_, arg2: Internal.SecureRandom_): void;
        getExemptionMechanism(): Internal.ExemptionMechanism;
        static getInstance(arg0: string): Internal.Cipher;
        updateAAD(arg0: Internal.ByteBuffer_): void;
        update(arg0: number[], arg1: number, arg2: number): number[];
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.SecureRandom_): void;
        updateAAD(arg0: number[]): void;
        static getInstance(arg0: string, arg1: Internal.Provider_): Internal.Cipher;
        doFinal(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number): number;
        getIV(): number[];
        doFinal(arg0: Internal.ByteBuffer_, arg1: Internal.ByteBuffer_): number;
        update(arg0: Internal.ByteBuffer_, arg1: Internal.ByteBuffer_): number;
        init(arg0: number, arg1: Internal.Certificate_): void;
        update(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number): number;
        static getInstance(arg0: string, arg1: string): Internal.Cipher;
        getProvider(): Internal.Provider;
        getOutputSize(arg0: number): number;
        static getMaxAllowedParameterSpec(arg0: string): Internal.AlgorithmParameterSpec;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameters_): void;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameters_, arg3: Internal.SecureRandom_): void;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameterSpec_, arg3: Internal.SecureRandom_): void;
        updateAAD(arg0: number[], arg1: number, arg2: number): void;
        static getMaxAllowedKeyLength(arg0: string): number;
        getBlockSize(): number;
        init(arg0: number, arg1: Internal.Key_, arg2: Internal.AlgorithmParameterSpec_): void;
        unwrap(arg0: number[], arg1: string, arg2: number): Internal.Key;
        get parameters(): Internal.AlgorithmParameters
        get algorithm(): string
        get exemptionMechanism(): Internal.ExemptionMechanism
        get IV(): number[]
        get provider(): Internal.Provider
        get blockSize(): number
        static readonly SECRET_KEY: 3;
        static readonly ENCRYPT_MODE: 1;
        static readonly PUBLIC_KEY: 1;
        static readonly PRIVATE_KEY: 2;
        static readonly WRAP_MODE: 3;
        static readonly UNWRAP_MODE: 4;
        static readonly DECRYPT_MODE: 2;
    }
    type Cipher_ = Cipher;
    class PotionItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PotionItem_ = PotionItem;
    class FillLayerFeature extends Internal.Feature<Internal.LayerConfiguration> {
        constructor($$0: Internal.Codec_<Internal.LayerConfiguration>)
    }
    type FillLayerFeature_ = FillLayerFeature;
    class ClientboundServerDataPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: net.minecraft.network.chat.Component_, $$1: Internal.Optional_<number[]>, $$2: boolean)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getIconBytes(): Internal.Optional<number[]>;
        write($$0: Internal.FriendlyByteBuf_): void;
        enforcesSecureChat(): boolean;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getMotd(): net.minecraft.network.chat.Component;
        isSkippable(): boolean;
        get iconBytes(): Internal.Optional<number[]>
        get motd(): net.minecraft.network.chat.Component
        get skippable(): boolean
    }
    type ClientboundServerDataPacket_ = ClientboundServerDataPacket;
    class EyeOfEnder extends Internal.Entity implements Internal.ItemSupplier {
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        constructor($$0: Internal.EntityType_<Internal.EyeOfEnder>, $$1: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem($$0: Internal.ItemStack_): void;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        signalTo($$0: BlockPos_): void;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        method_5652($$0: Internal.CompoundTag_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        method_5749($$0: Internal.CompoundTag_): void;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set item($$0: Internal.ItemStack_)
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type EyeOfEnder_ = EyeOfEnder;
    class PathNavigationRegion implements Internal.ChunkView, Internal.CollisionGetter, Internal.BlockGetter {
        constructor($$0: Internal.Level_, $$1: BlockPos_, $$2: BlockPos_)
        noCollision($$0: Internal.Entity_): boolean;
        getMinSection(): number;
        getBlockState(pos: BlockPos_): Internal.BlockState;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getProfiler(): Internal.ProfilerFiller;
        getSectionYFromSectionIndex($$0: number): number;
        noCollision($$0: Internal.AABB_): boolean;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getHeight(): number;
        getBlockEntity($$0: BlockPos_): Internal.BlockEntity;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getWorldBorder(): Internal.WorldBorder;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getFluidState(pos: BlockPos_): Internal.FluidState;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        getChunkForCollisions($$0: number, $$1: number): Internal.BlockGetter;
        hasBiomes(): boolean;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get profiler(): Internal.ProfilerFiller
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get minBuildHeight(): number
        get sectionsCount(): number
        get maxLightLevel(): number
    }
    type PathNavigationRegion_ = PathNavigationRegion;
    interface Logger {
        abstract trace(arg0: string, ...arg1: any[]): void;
        abstract error(arg0: string): void;
        abstract warn(arg0: string, arg1: any, arg2: any): void;
        abstract isTraceEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract info(arg0: string, arg1: Internal.Throwable_): void;
        abstract debug(arg0: string): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract error(arg0: string, ...arg1: any[]): void;
        abstract warn(arg0: string, arg1: any): void;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract info(arg0: string): void;
        atTrace(): Internal.LoggingEventBuilder;
        isEnabledForLevel(arg0: org.slf4j.event.Level_): boolean;
        abstract debug(arg0: string, ...arg1: any[]): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract warn(arg0: string, arg1: Internal.Throwable_): void;
        atDebug(): Internal.LoggingEventBuilder;
        abstract info(arg0: string, arg1: any): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract isTraceEnabled(): boolean;
        abstract isWarnEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract trace(arg0: string): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract debug(arg0: string, arg1: any, arg2: any): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract trace(arg0: string, arg1: any): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract trace(arg0: string, arg1: any, arg2: any): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract isDebugEnabled(): boolean;
        atWarn(): Internal.LoggingEventBuilder;
        makeLoggingEventBuilder(arg0: org.slf4j.event.Level_): Internal.LoggingEventBuilder;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract error(arg0: string, arg1: any): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract warn(arg0: string): void;
        abstract warn(arg0: string, ...arg1: any[]): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract isErrorEnabled(): boolean;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract isWarnEnabled(): boolean;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract error(arg0: string, arg1: any, arg2: any): void;
        abstract getName(): string;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract debug(arg0: string, arg1: any): void;
        abstract isErrorEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract info(arg0: string, arg1: any, arg2: any): void;
        abstract isInfoEnabled(): boolean;
        atInfo(): Internal.LoggingEventBuilder;
        atError(): Internal.LoggingEventBuilder;
        abstract debug(arg0: string, arg1: Internal.Throwable_): void;
        abstract info(arg0: string, ...arg1: any[]): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract isDebugEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract isInfoEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract trace(arg0: string, arg1: Internal.Throwable_): void;
        abstract error(arg0: string, arg1: Internal.Throwable_): void;
        atLevel(arg0: org.slf4j.event.Level_): Internal.LoggingEventBuilder;
        get traceEnabled(): boolean
        get debugEnabled(): boolean
        get errorEnabled(): boolean
        get warnEnabled(): boolean
        get name(): string
        get infoEnabled(): boolean
        readonly ROOT_LOGGER_NAME: "ROOT";
    }
    type Logger_ = Logger;
}
declare namespace net.blay09.mods.balm.mixin {
    interface ScreenAccessor {
        abstract balm_getRenderables(): Internal.List<Internal.Renderable>;
        abstract balm_getChildren(): Internal.List<Internal.GuiEventListener>;
        abstract balm_getNarratables(): Internal.List<Internal.NarratableEntry>;
    }
    type ScreenAccessor_ = ScreenAccessor;
}
declare namespace dev.engine_room.flywheel.api.model {
    interface Mesh {
        abstract boundingSphere(): Internal.Vector4fc;
        abstract indexSequence(): Internal.IndexSequence;
        abstract indexCount(): number;
        abstract write(arg0: Internal.MutableVertexList_): void;
        abstract vertexCount(): number;
    }
    type Mesh_ = Mesh;
}
declare namespace it.unimi.dsi.fastutil.booleans {
    interface BooleanConsumer extends Internal.Consumer<boolean> {
        /**
         * @deprecated
        */
        accept(arg0: any): void;
        andThen(arg0: it.unimi.dsi.fastutil.booleans.BooleanConsumer_): this;
        /**
         * @deprecated
        */
        accept(arg0: boolean): void;
        abstract accept(arg0: boolean): void;
        /**
         * @deprecated
        */
        andThen(arg0: Internal.Consumer_<boolean>): Internal.Consumer<boolean>;
        (arg0: boolean): void;
    }
    type BooleanConsumer_ = BooleanConsumer;
}
